/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.compat.jei.categories;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.client.render.dye_liquifier.DyeLiquifierContainerScreen;
import wootrevived.woot.compat.jei.WootJeiPluginTypes;
import wootrevived.woot.config.DyeLiquifierConfig;
import wootrevived.woot.events.client.GlobalClientTicker;
import wootrevived.woot.recipes.dye_liquifier.DyeLiquifierRecipe;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.FluidsRegistry;
import wootrevived.woot.util.render.WootContainerScreen;

public class DyeLiquifierRecipeCategory
implements IRecipeCategory<DyeLiquifierRecipe> {
    private static IDrawable icon;
    private static final int GUI_WIDTH = 119;
    private static final int GUI_HEIGHT = 56;
    private static final int ENERGY_X = 0;
    private static final int ENERGY_Y = 0;
    private static final int INPUT_SLOT_X = 21;
    private static final int INPUT_SLOT_Y = 19;
    private static final int COLOR_BAR_X = 63;
    private static final int RED_COLOR_BAR_Y = 5;
    private static final int YELLOW_COLOR_BAR_Y = 17;
    private static final int BLUE_COLOR_BAR_Y = 29;
    private static final int WHITE_COLOR_BAR_Y = 41;
    private static final int PROGRESS_X = 42;
    private static final int PROGRESS_Y = 7;

    public DyeLiquifierRecipeCategory(IGuiHelper guiHelper) {
        icon = guiHelper.createDrawableItemLike((ItemLike)BlocksRegistry.DYE_LIQUIFIER_BLOCK.get());
    }

    public void draw(DyeLiquifierRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics gui, double mouseX, double mouseY) {
        int totalProgressTick = recipe.getEnergy() / (Integer)DyeLiquifierConfig.ENERGY_PROCESS_TRANSFER.get();
        int progress = GlobalClientTicker.tickCounter % totalProgressTick * 100 / totalProgressTick;
        WootContainerScreen.renderVanillaSlot(gui, 21, 19);
        WootContainerScreen.renderColorBarBg(gui, 63, 5, DyeColor.RED.m_41068_());
        WootContainerScreen.renderColorBarBg(gui, 63, 17, DyeColor.YELLOW.m_41068_());
        WootContainerScreen.renderColorBarBg(gui, 63, 29, DyeColor.BLUE.m_41068_());
        WootContainerScreen.renderColorBarBg(gui, 63, 41, DyeColor.WHITE.m_41068_());
        WootContainerScreen.renderEnergyBg(gui, 0, 0);
        DyeLiquifierContainerScreen.renderProgressBg(gui, 42, 7);
        WootContainerScreen.renderEnergy(gui, 0, 0, recipe.getEnergy(), (Integer)DyeLiquifierConfig.ENERGY_CAPACITY.get());
        WootContainerScreen.renderColorBar(gui, 63, 5, recipe.getRed(), Math.round((float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue() * DyeLiquifierRecipe.maxMultiplier), DyeColor.RED.m_41068_());
        WootContainerScreen.renderColorBar(gui, 63, 17, recipe.getYellow(), Math.round((float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue() * DyeLiquifierRecipe.maxMultiplier), DyeColor.YELLOW.m_41068_());
        WootContainerScreen.renderColorBar(gui, 63, 29, recipe.getBlue(), Math.round((float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue() * DyeLiquifierRecipe.maxMultiplier), DyeColor.BLUE.m_41068_());
        WootContainerScreen.renderColorBar(gui, 63, 41, recipe.getWhite(), Math.round((float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue() * DyeLiquifierRecipe.maxMultiplier), DyeColor.WHITE.m_41068_());
        DyeLiquifierContainerScreen.renderProgress(gui, 42, 7, progress);
        WootContainerScreen._renderEnergyTooltip(gui, (int)mouseX, (int)mouseY, 0, 0, recipe.getEnergy(), (Integer)DyeLiquifierConfig.ENERGY_CAPACITY.get(), false, false);
        WootContainerScreen._renderColorBarTooltip(gui, (int)mouseX, (int)mouseY, 63, 5, recipe.getRed(), 0, Component.m_237115_((String)"info.woot_revived.dye.red"), false, false);
        WootContainerScreen._renderColorBarTooltip(gui, (int)mouseX, (int)mouseY, 63, 17, recipe.getYellow(), 0, Component.m_237115_((String)"info.woot_revived.dye.yellow"), false, false);
        WootContainerScreen._renderColorBarTooltip(gui, (int)mouseX, (int)mouseY, 63, 29, recipe.getBlue(), 0, Component.m_237115_((String)"info.woot_revived.dye.blue"), false, false);
        WootContainerScreen._renderColorBarTooltip(gui, (int)mouseX, (int)mouseY, 63, 41, recipe.getWhite(), 0, Component.m_237115_((String)"info.woot_revived.dye.white"), false, false);
        DyeLiquifierContainerScreen._renderProgressTooltip(gui, (int)mouseX, (int)mouseY, 42, 7, progress, Math.max(0.0f, (float)totalProgressTick / 20.0f), (Integer)DyeLiquifierConfig.ENERGY_PROCESS_TRANSFER.get(), false);
    }

    public int getWidth() {
        return 119;
    }

    public int getHeight() {
        return 56;
    }

    @NotNull
    public RecipeType<DyeLiquifierRecipe> getRecipeType() {
        return WootJeiPluginTypes.DYE_LIQUIFIER_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"gui.woot_revived.dye_liquifier.name");
    }

    @Nullable
    public IDrawable getIcon() {
        return icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DyeLiquifierRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addInputSlot(22, 20).addIngredients(recipe.getIngredient());
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addFluidStack((Fluid)FluidsRegistry.SOURCE_PURE_DYE_FLUID.get()).addItemLike((ItemLike)FluidsRegistry.PURE_DYE_FLUID_BUCKET.get());
    }
}

