/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.compat.jei.categories;

import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.compat.jei.WootJeiCustomFluidRenderer;
import wootrevived.woot.compat.jei.WootJeiPluginTypes;
import wootrevived.woot.config.EnchantedLiquifierConfig;
import wootrevived.woot.events.client.GlobalClientTicker;
import wootrevived.woot.recipes.enchanted_liquifier.EnchantedLiquifierRecipe;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.render.WootContainerScreen;

public class EnchantedLiquifierRecipeCategory
implements IRecipeCategory<EnchantedLiquifierRecipe> {
    private static IDrawable icon;
    private static final int GUI_WIDTH = 85;
    private static final int GUI_HEIGHT = 56;
    private static final int ENERGY_X = 0;
    private static final int ENERGY_Y = 0;
    private static final int INPUT_SLOT_X = 21;
    private static final int INPUT_SLOT_Y = 19;
    private static final int OUTPUT_FLUID_X = 67;
    private static final int OUTPUT_FLUID_Y = 0;
    private static final int PROGRESS_X = 42;
    private static final int PROGRESS_Y = 20;

    public EnchantedLiquifierRecipeCategory(IGuiHelper guiHelper) {
        icon = guiHelper.createDrawableItemLike((ItemLike)BlocksRegistry.ENCHANTED_LIQUIFIER_BLOCK.get());
    }

    public void draw(EnchantedLiquifierRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics gui, double mouseX, double mouseY) {
        int totalProgressTick = recipe.getEnergy() / (Integer)EnchantedLiquifierConfig.ENERGY_PROCESS_TRANSFER.get();
        int progress = GlobalClientTicker.tickCounter % totalProgressTick * 100 / totalProgressTick;
        WootContainerScreen.renderVanillaSlot(gui, 21, 19);
        WootContainerScreen.renderEnergyBg(gui, 0, 0);
        WootContainerScreen.renderFluidBg(gui, 67, 0);
        WootContainerScreen.renderProgressArrowBg(gui, 42, 20);
        WootContainerScreen.renderEnergy(gui, 0, 0, recipe.getEnergy(), (Integer)EnchantedLiquifierConfig.ENERGY_CAPACITY.get());
        WootContainerScreen.renderProgressArrow(gui, 42, 20, progress);
        WootContainerScreen._renderEnergyTooltip(gui, (int)mouseX, (int)mouseY, 0, 0, recipe.getEnergy(), (Integer)EnchantedLiquifierConfig.ENERGY_CAPACITY.get(), false, false);
        WootContainerScreen._renderProgressArrowTooltip(gui, (int)mouseX, (int)mouseY, 42, 20, progress, Math.max(0.0f, (float)totalProgressTick / 20.0f), (Integer)EnchantedLiquifierConfig.ENERGY_PROCESS_TRANSFER.get(), false);
    }

    public int getWidth() {
        return 85;
    }

    public int getHeight() {
        return 56;
    }

    @NotNull
    public RecipeType<EnchantedLiquifierRecipe> getRecipeType() {
        return WootJeiPluginTypes.ENCHANTED_LIQUIFIER_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"gui.woot_revived.enchanted_liquifier.name");
    }

    @Nullable
    public IDrawable getIcon() {
        return icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EnchantedLiquifierRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addInputSlot(22, 20).addIngredients(recipe.getIngredient());
        FluidStack outputFluid = recipe.getOutput();
        ((IRecipeSlotBuilder)builder.addOutputSlot(70, 3).addFluidStack(outputFluid.getFluid(), (long)outputFluid.getAmount())).setCustomRenderer((IIngredientType)ForgeTypes.FLUID_STACK, (IIngredientRenderer)new WootJeiCustomFluidRenderer((Integer)EnchantedLiquifierConfig.OUTPUT_TANK_CAPACITY.get()));
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemLike((ItemLike)outputFluid.getFluid().m_6859_());
    }
}

