/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.compat.kubejs;

import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.event.EventExit;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.event.Extra;
import dev.latvian.mods.kubejs.script.ScriptType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.api.registrations.WootFactoryMobRegistration;
import wootrevived.woot.compat.kubejs.mobs.WootDropsPropertiesJS;
import wootrevived.woot.compat.kubejs.mobs.WootFactoryMobEventJS;

public interface WootStartupEvents {
    public static final EventGroup GROUP = EventGroup.of((String)"WootStartupEvents");
    public static final Extra MOBS_EXTRA = Extra.REQUIRES_STRING.copy().validator(WootStartupEvents::validateMob);
    public static final EventHandler MOBS = GROUP.startup("registerFactoryMob", () -> WootFactoryMobEventJS.class).extra(MOBS_EXTRA);
    public static final EventHandler DROPS = GROUP.startup("registerGlobalDropsModifier", () -> WootDropsPropertiesJS.class);

    private static boolean validateMob(Object o) {
        try {
            ResourceLocation location = ResourceLocation.m_135820_((String)o.toString());
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(location);
            return entityType != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void postFactoryMobs(WootFactoryMobRegistration registration) {
        registration.registerGlobalDropsModifier(WootStartupEvents::postGlobalDropsModifier);
        MOBS.forEachListener(ScriptType.STARTUP, handler -> {
            ResourceLocation location = ResourceLocation.m_135820_((String)handler.extraId.toString());
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(location);
            WootFactoryMobEventJS event = new WootFactoryMobEventJS(registration, entityType);
            try {
                handler.handle((EventJS)event, null);
            }
            catch (EventExit eventExit) {
                if (eventExit.result.type() == EventResult.Type.ERROR) {
                    if (DevProperties.get().debugInfo) {
                        ((Throwable)eventExit.result.value()).printStackTrace();
                    }
                    ScriptType.STARTUP.console.error("Error in '" + String.valueOf(MOBS) + "'", (Throwable)eventExit.result.value());
                }
                ScriptType.STARTUP.console.error("Error in '" + String.valueOf(MOBS) + "'", (Throwable)new IllegalStateException("Event returned result when it's not cancellable"));
            }
        });
    }

    public static void postGlobalDropsModifier(WootDropsProperties properties) {
        DROPS.post((EventJS)new WootDropsPropertiesJS(properties));
    }
}

