/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.compat.kubejs.mobs;

import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.woot.compat.kubejs.mobs.WootDropsPropertiesJS;

public class KubeJSMob<T extends Entity>
extends WootFactoryMob<T> {
    private final WootFactoryMob<T> mob;
    private final List<ItemStack> importItems;
    private final List<FluidStack> importFluids;
    private final BiConsumer<String, WootDropsPropertiesJS> modifyDrops;

    public KubeJSMob(EntityType<T> entityType, WootFactoryMob.Properties properties, WootFactoryMob<T> mob, List<ItemStack> importItems, List<FluidStack> importFluids, @Nullable BiConsumer<String, WootDropsPropertiesJS> modifyDrops) {
        super(entityType, properties);
        this.mob = mob;
        this.importItems = importItems;
        this.importFluids = importFluids;
        this.modifyDrops = modifyDrops;
    }

    @Override
    public MutableComponent getDisplayName(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        return this.mob.getDisplayName(mobTag, lookupProvider);
    }

    @Override
    public MutableComponent getTooltipKillName(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        return this.mob.getTooltipKillName(mobTag, lookupProvider);
    }

    @Override
    public CompoundTag saveTag(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        return this.mob.saveTag(mobTag, lookupProvider);
    }

    @Override
    public boolean isSame(CompoundTag shardTag, CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        return this.mob.isSame(shardTag, mobTag, lookupProvider);
    }

    @Override
    public void modifyDrops(WootFactoryMob.Phase phase, WootDropsProperties properties) {
        if (this.modifyDrops == null) {
            this.mob.modifyDrops(phase, properties);
            return;
        }
        this.modifyDrops.accept(phase.name(), new WootDropsPropertiesJS(properties));
    }

    @Override
    public List<ItemStack> getImportItems(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        if (this.importItems.isEmpty()) {
            return this.mob.getImportItems(mobTag, lookupProvider);
        }
        return this.importItems;
    }

    @Override
    public List<FluidStack> getImportFluids(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        if (this.importFluids.isEmpty()) {
            return this.mob.getImportFluids(mobTag, lookupProvider);
        }
        return this.importFluids;
    }
}

