/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class DyeLiquifierConfig {
    public static ForgeConfigSpec.ConfigValue<Integer> ENERGY_CAPACITY;
    public static ForgeConfigSpec.ConfigValue<Integer> ENERGY_MAX_TRANSFER;
    public static ForgeConfigSpec.ConfigValue<Integer> ENERGY_PROCESS_TRANSFER;
    public static ForgeConfigSpec.ConfigValue<Integer> FLUID_TRANSFER;
    public static ForgeConfigSpec.ConfigValue<Integer> OUTPUT_TANK_CAPACITY;
    public static ForgeConfigSpec.ConfigValue<Integer> COLOR_PRODUCE_AMOUNT;
    public static ForgeConfigSpec.ConfigValue<Integer> PURE_DYE_PRODUCE_AMOUNT;
    public static ForgeConfigSpec.ConfigValue<Integer> RED_TANK_CAPACITY;
    public static ForgeConfigSpec.ConfigValue<Integer> YELLOW_TANK_CAPACITY;
    public static ForgeConfigSpec.ConfigValue<Integer> BLUE_TANK_CAPACITY;
    public static ForgeConfigSpec.ConfigValue<Integer> WHITE_TANK_CAPACITY;

    public static void build(ForgeConfigSpec.Builder builder) {
        builder.comment("Dye Liquifier").push("dye_liquifier");
        ENERGY_CAPACITY = builder.comment(String.format("The energy capacity of the Dye Liquifier [Default: %d]", 25000)).define("energyCapacity", (Object)25000);
        ENERGY_MAX_TRANSFER = builder.comment(String.format("The max energy in/out transfer rate of the Dye Liquifier [Default: %d]", 1000)).define("energyMaxTransfer", (Object)1000);
        ENERGY_PROCESS_TRANSFER = builder.comment(String.format("The energy transfer rate of the Dye Liquifier [Default: %d]", 50)).define("energyProcessTransfer", (Object)50);
        FLUID_TRANSFER = builder.comment(String.format("The fluid transfer rate of the Dye Liquifier [Default: %d]", 500)).define("fluidTransfer", (Object)500);
        OUTPUT_TANK_CAPACITY = builder.comment(String.format("The output tank capacity of the Dye Liquifier [Default: %d]", 25000)).define("outputTankCapacity", (Object)25000);
        COLOR_PRODUCE_AMOUNT = builder.comment(String.format("The reference amount of color produce per dye [Default: %d]", 125)).define("colorProduceAmount", (Object)125);
        PURE_DYE_PRODUCE_AMOUNT = builder.comment(String.format("Amount of pure dye produced after conversion conditions are met [Default: %d]", 500)).define("pureDyeProduceAmount", (Object)500);
        RED_TANK_CAPACITY = builder.comment(String.format("The internal red tank capacity of the Dye Liquifier [Default: %d]", 12500)).define("redTankCapacity", (Object)12500);
        YELLOW_TANK_CAPACITY = builder.comment(String.format("The internal yellow tank capacity of the Dye Liquifier [Default: %d]", 12500)).define("yellowTankCapacity", (Object)12500);
        BLUE_TANK_CAPACITY = builder.comment(String.format("The internal blue tank capacity of the Dye Liquifier [Default: %d]", 12500)).define("blueTankCapacity", (Object)12500);
        WHITE_TANK_CAPACITY = builder.comment(String.format("The internal white tank capacity of the Dye Liquifier [Default: %d]", 12500)).define("whiteTankCapacity", (Object)12500);
        builder.pop();
    }
}

