/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.datagen;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import wootrevived.woot.datagen.Advancements;
import wootrevived.woot.datagen.Atlas;
import wootrevived.woot.datagen.BlockTagsGen;
import wootrevived.woot.datagen.Blocks;
import wootrevived.woot.datagen.DropSimulatorDim;
import wootrevived.woot.datagen.ItemTagsGen;
import wootrevived.woot.datagen.Items;
import wootrevived.woot.datagen.Languages;
import wootrevived.woot.datagen.LootTables;
import wootrevived.woot.datagen.Recipes;

@Mod.EventBusSubscriber(modid="woot_revived", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        PackOutput packOutput = generator.getPackOutput();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new Recipes(packOutput));
            BlockTagsGen blockTagsProvider = new BlockTagsGen(packOutput, lookupProvider, existingFileHelper);
            generator.addProvider(true, (DataProvider)blockTagsProvider);
            generator.addProvider(true, (DataProvider)new ItemTagsGen(packOutput, lookupProvider, blockTagsProvider.m_274426_(), existingFileHelper));
            generator.addProvider(true, (DataProvider)new DropSimulatorDim(packOutput, lookupProvider));
            generator.addProvider(true, (DataProvider)new Advancements(packOutput, lookupProvider, existingFileHelper));
            generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(LootTables::new, LootContextParamSets.f_81421_))));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new Blocks(packOutput, existingFileHelper));
            generator.addProvider(true, (DataProvider)new Items(packOutput, existingFileHelper));
            generator.addProvider(true, (DataProvider)new Atlas(packOutput, existingFileHelper));
            generator.addProvider(true, (DataProvider)new Languages(packOutput));
        }
    }
}

