/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.datagen;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.registries.BlocksRegistry;

public class LootTables
extends BlockLootSubProvider {
    public LootTables() {
        super(Set.of(), FeatureFlags.f_244280_.m_247355_());
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return BlocksRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get).collect(Collectors.toList());
    }

    protected void m_245660_() {
        this.dropSelf(BlocksRegistry.STYGIAN_ANVIL_BLOCK);
        this.dropSelf(BlocksRegistry.FACTORY_BASE_BLOCK);
        this.dropSelf(BlocksRegistry.STYGIAN_BLOCK);
        this.copyTagWithEnable(BlocksRegistry.FAKE_SPAWNER_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("Mob", "BlockEntityTag.Mob", CopyNbtFunction.MergeStrategy.REPLACE));
        this.dropSelfWithEnable(BlocksRegistry.COPPER_PLINTH_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.COPPER_PYLON_BLOCK);
        this.copyTagWithEnable(BlocksRegistry.COPPER_CELL_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("InputTank", "BlockEntityTag.InputTank", CopyNbtFunction.MergeStrategy.REPLACE));
        this.dropSelfWithEnable(BlocksRegistry.IRON_PLINTH_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.IRON_PYLON_BLOCK);
        this.copyTagWithEnable(BlocksRegistry.IRON_CELL_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("InputTank", "BlockEntityTag.InputTank", CopyNbtFunction.MergeStrategy.REPLACE));
        this.dropSelfWithEnable(BlocksRegistry.GOLD_PLINTH_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.GOLD_PYLON_BLOCK);
        this.copyTagWithEnable(BlocksRegistry.GOLD_CELL_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("InputTank", "BlockEntityTag.InputTank", CopyNbtFunction.MergeStrategy.REPLACE));
        this.dropSelfWithEnable(BlocksRegistry.DIAMOND_PLINTH_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.DIAMOND_PYLON_BLOCK);
        this.copyTagWithEnable(BlocksRegistry.DIAMOND_CELL_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("InputTank", "BlockEntityTag.InputTank", CopyNbtFunction.MergeStrategy.REPLACE));
        this.dropSelfWithEnable(BlocksRegistry.NETHERITE_PLINTH_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.NETHERITE_PYLON_BLOCK);
        this.copyTagWithEnable(BlocksRegistry.NETHERITE_CELL_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("InputTank", "BlockEntityTag.InputTank", CopyNbtFunction.MergeStrategy.REPLACE));
        this.dropSelfWithEnable(BlocksRegistry.HEART_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.FACTORY_UPGRADE_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.FACTORY_CONNECT_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.FACTORY_CTR_BASE_PRI_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.FACTORY_CTR_BASE_SEC_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.IMPORT_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.EXPORT_BLOCK);
        this.dropSelf(BlocksRegistry.LAYOUT_BLOCK);
        this.dropSelf(BlocksRegistry.CREATIVE_POWER_BLOCK);
        this.copyTag(BlocksRegistry.CREATIVE_TANK_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("InputTank", "BlockEntityTag.InputTank", CopyNbtFunction.MergeStrategy.REPLACE));
        this.copyTag(BlocksRegistry.FLUID_INFUSER_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("Energy", "BlockEntityTag.Energy", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("InputTank", "BlockEntityTag.InputTank", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("OutputTank", "BlockEntityTag.OutputTank", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("RedstoneMode", "BlockEntityTag.RedstoneMode", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("MachineProperties", "BlockEntityTag.MachineProperties", CopyNbtFunction.MergeStrategy.REPLACE));
        this.copyTag(BlocksRegistry.ITEM_INFUSER_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("Energy", "BlockEntityTag.Energy", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("InputTank", "BlockEntityTag.InputTank", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("RedstoneMode", "BlockEntityTag.RedstoneMode", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("MachineProperties", "BlockEntityTag.MachineProperties", CopyNbtFunction.MergeStrategy.REPLACE));
        this.copyTag(BlocksRegistry.ENCHANTED_LIQUIFIER_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("Energy", "BlockEntityTag.Energy", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("OutputTank", "BlockEntityTag.OutputTank", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("RedstoneMode", "BlockEntityTag.RedstoneMode", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("MachineProperties", "BlockEntityTag.MachineProperties", CopyNbtFunction.MergeStrategy.REPLACE));
        this.copyTag(BlocksRegistry.DYE_LIQUIFIER_BLOCK, (LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("Energy", "BlockEntityTag.Energy", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("OutputTank", "BlockEntityTag.OutputTank", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("RedstoneMode", "BlockEntityTag.RedstoneMode", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("MachineProperties", "BlockEntityTag.MachineProperties", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("InternalTanks", "BlockEntityTag.InternalTanks", CopyNbtFunction.MergeStrategy.REPLACE));
    }

    public ResourceLocation getBlockResource(Block block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block));
    }

    public void dropSelf(RegistryObject<?> block) {
        this.m_247577_((Block)block.get(), LootTables.m_246386_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((Block)block.get()))).m_79073_()));
    }

    public void dropSelfWithEnable(RegistryObject<?> block) {
        LootItemBlockStatePropertyCondition.Builder builder = LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)block.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)BlockStateProperties.f_61431_, true));
        this.m_247577_((Block)block.get(), LootTables.m_246386_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((Block)block.get())).m_79080_((LootItemCondition.Builder)builder))));
    }

    public void copyTag(RegistryObject<?> block, LootItemFunction.Builder builder) {
        this.m_247577_((Block)block.get(), LootTables.m_246386_().m_79161_(LootPool.m_79043_().name(this.getBlockResource((Block)block.get()).toString()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((Block)block.get()).m_5456_()).m_79078_(builder))));
    }

    public void copyTagWithEnable(RegistryObject<?> block, LootItemFunction.Builder builder) {
        LootItemBlockStatePropertyCondition.Builder stateBuilder = LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)block.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)BlockStateProperties.f_61431_, true));
        this.m_247577_((Block)block.get(), LootTables.m_246386_().m_79161_(LootPool.m_79043_().name(this.getBlockResource((Block)block.get()).toString()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_((LootItemCondition.Builder)stateBuilder).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((Block)block.get()).m_5456_()).m_79078_(builder))));
    }
}

