/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.drops.mobs;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Creeper;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.enums.Tier;
import wootrevived.api.registrations.WootFactoryMobRegistration;

public class CreeperMob
extends WootFactoryMob<Creeper> {
    public CreeperMob(EntityType<Creeper> entityType, WootFactoryMob.Properties properties) {
        super(entityType, properties);
    }

    @Override
    public MutableComponent getDisplayName(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        MutableComponent tip = Component.m_237119_();
        if (mobTag.m_128441_("powered") && mobTag.m_128471_("powered")) {
            tip.m_130946_("Charged ");
        }
        return tip.m_7220_((Component)super.getDisplayName(mobTag, lookupProvider));
    }

    @Override
    public CompoundTag saveTag(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        CompoundTag tag = super.saveTag(mobTag, lookupProvider);
        if (mobTag.m_128441_("powered")) {
            tag.m_128379_("powered", mobTag.m_128471_("powered"));
        }
        return tag;
    }

    @Override
    public boolean isSame(CompoundTag shardTag, CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        if (!super.isSame(shardTag, mobTag, lookupProvider)) {
            return false;
        }
        boolean isShardPowered = shardTag.m_128441_("powered") && shardTag.m_128471_("powered");
        boolean isMobPowered = mobTag.m_128441_("powered") && mobTag.m_128471_("powered");
        return isShardPowered == isMobPowered;
    }

    public static void register(WootFactoryMobRegistration registration) {
        registration.registerFactoryMob(new CreeperMob((EntityType<Creeper>)EntityType.f_20558_, new WootFactoryMob.Properties().tier(Tier.TIER_2)));
    }
}

