/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.drops.mobs;

import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.enums.Tier;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.api.registrations.WootFactoryMobRegistration;
import wootrevived.woot.util.helper.EnchantmentHelper;

public class EnderDragonMob
extends WootFactoryMob<EnderDragon> {
    public EnderDragonMob(EntityType<EnderDragon> entityType, WootFactoryMob.Properties properties) {
        super(entityType, properties);
    }

    @Override
    public void modifyDrops(WootFactoryMob.Phase phase, WootDropsProperties properties) {
        if (!phase.isBeforeDropCallback()) {
            return;
        }
        List<ItemStack> generatedDrops = properties.getItemDrops();
        generatedDrops.add(Items.f_42104_.m_7968_());
        int looting = 0;
        ItemStack stack = properties.getMainHandItem();
        if (EnchantmentHelper.isEnchanted(stack)) {
            looting = stack.getEnchantmentLevel(Enchantments.f_44982_);
        }
        ItemStack dragonBreath = Items.f_42735_.m_7968_();
        dragonBreath.m_41764_(16 * (looting + 1));
        generatedDrops.add(dragonBreath);
        if (properties.doSimulateChargedCreeper()) {
            generatedDrops.add(Items.f_42683_.m_7968_());
        }
    }

    @Override
    public List<ItemStack> getImportItems(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        ItemStack endCrystal = Items.f_42729_.m_7968_();
        endCrystal.m_41764_(4);
        return List.of(endCrystal);
    }

    public static void register(WootFactoryMobRegistration registration) {
        registration.registerFactoryMob(new EnderDragonMob((EntityType<EnderDragon>)EntityType.f_20565_, new WootFactoryMob.Properties().tier(Tier.TIER_5)));
    }
}

