/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.drops.mobs;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Slime;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.enums.Tier;
import wootrevived.api.registrations.WootFactoryMobRegistration;

public class SlimeMob
extends WootFactoryMob<Slime> {
    public SlimeMob(EntityType<Slime> entityType, WootFactoryMob.Properties properties) {
        super(entityType, properties);
    }

    @Override
    public MutableComponent getDisplayName(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        MutableComponent tip = Component.m_237113_((String)(mobTag.m_128451_("Size") > 0 ? "Large " : "Small "));
        return tip.m_7220_((Component)super.getDisplayName(mobTag, lookupProvider));
    }

    @Override
    public CompoundTag saveTag(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        CompoundTag tag = super.saveTag(mobTag, lookupProvider);
        tag.m_128405_("Size", mobTag.m_128451_("Size"));
        return tag;
    }

    @Override
    public boolean isSame(CompoundTag shardTag, CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        if (!super.isSame(shardTag, mobTag, lookupProvider)) {
            return false;
        }
        boolean isShardLarge = shardTag.m_128451_("Size") > 0;
        boolean isMobLarge = mobTag.m_128451_("Size") > 0;
        return isShardLarge == isMobLarge;
    }

    public static void register(WootFactoryMobRegistration registration) {
        registration.registerFactoryMob(new SlimeMob((EntityType<Slime>)EntityType.f_20526_, new WootFactoryMob.Properties().tier(Tier.TIER_2)));
    }
}

