/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.drops.mobs;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.registrations.WootFactoryMobRegistration;

public class VillagerMob
extends WootFactoryMob<Villager> {
    public VillagerMob(EntityType<Villager> entityType, WootFactoryMob.Properties properties) {
        super(entityType, properties);
    }

    @Override
    public MutableComponent getDisplayName(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        MutableComponent component = Component.m_237119_();
        Tag villagerData = mobTag.m_128423_("VillagerData");
        DataResult result = VillagerData.f_35550_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)villagerData));
        result.result().ifPresent(data -> {
            if (data.m_35571_() == VillagerProfession.f_35585_) {
                return;
            }
            component.m_7220_((Component)Component.m_237115_((String)("entity.minecraft.villager." + data.m_35571_().f_35600_().toLowerCase())));
            component.m_7220_((Component)Component.m_237113_((String)" "));
        });
        component.m_7220_((Component)super.getDisplayName(mobTag, lookupProvider));
        return component;
    }

    @Override
    public MutableComponent getTooltipKillName(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        return super.getDisplayName(mobTag, lookupProvider);
    }

    @Override
    public CompoundTag saveTag(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        CompoundTag tag = super.saveTag(mobTag, lookupProvider);
        Tag villagerData = mobTag.m_128423_("VillagerData");
        if (villagerData != null) {
            tag.m_128365_("VillagerData", villagerData);
        }
        return tag;
    }

    public static void register(WootFactoryMobRegistration registration) {
        registration.registerFactoryMob(new VillagerMob((EntityType<Villager>)EntityType.f_20492_, new WootFactoryMob.Properties()));
    }
}

