/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.drops.mobs;

import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.enums.Tier;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.api.registrations.WootFactoryMobRegistration;
import wootrevived.woot.util.helper.EnchantmentHelper;

public class WitherMob
extends WootFactoryMob<WitherBoss> {
    public WitherMob(EntityType<WitherBoss> entityType, WootFactoryMob.Properties properties) {
        super(entityType, properties);
    }

    @Override
    public void modifyDrops(WootFactoryMob.Phase phase, WootDropsProperties properties) {
        if (!phase.isBeforeDropCallback()) {
            return;
        }
        List<ItemStack> generatedDrops = properties.getItemDrops();
        int looting = 0;
        ItemStack handStack = properties.getMainHandItem();
        if (EnchantmentHelper.isEnchanted(handStack)) {
            looting = handStack.getEnchantmentLevel(Enchantments.f_44982_);
        }
        ItemStack witherRose = Items.f_41951_.m_7968_();
        witherRose.m_41764_(1 + looting);
        generatedDrops.add(witherRose);
        if (properties.doSimulateChargedCreeper()) {
            for (ItemStack stack : List.copyOf(generatedDrops)) {
                if (!stack.m_150930_(Items.f_42686_)) continue;
                generatedDrops.remove(stack);
                break;
            }
        }
    }

    @Override
    public List<ItemStack> getImportItems(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        ItemStack witherSkeletonSkull = Items.f_42679_.m_7968_();
        witherSkeletonSkull.m_41764_(3);
        ItemStack soulSand = Items.f_42049_.m_7968_();
        soulSand.m_41764_(4);
        return List.of(witherSkeletonSkull, soulSand);
    }

    public static void register(WootFactoryMobRegistration registration) {
        registration.registerFactoryMob(new WitherMob((EntityType<WitherBoss>)EntityType.f_20496_, new WootFactoryMob.Properties().tier(Tier.TIER_5)));
    }
}

