/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.drops.simulator;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.woot.drops.simulator.FakeDragonFight;
import wootrevived.woot.drops.simulator.FakeEntityManager;
import wootrevived.woot.mixins.accessors.LevelMixinAccessor;
import wootrevived.woot.mixins.accessors.ServerLevelMixinAccessor;
import wootrevived.woot.mixins.impl.CreeperMixin;
import wootrevived.woot.mixins.impl.EndDragonFightMixin;
import wootrevived.woot.mixins.impl.EnderDragonMixin;
import wootrevived.woot.mixins.impl.LivingEntityMixin;
import wootrevived.woot.mixins.impl.PersistentEntitySectionManagerMixin;

public class DropSimulator {
    private static final DropSimulator INSTANCE = new DropSimulator();
    private final GameProfile gameProfile = new GameProfile(UUID.nameUUIDFromBytes("woot_revived".getBytes()), "woot_revived");
    private ServerLevel dimensionLevel = null;
    private ResourceKey<Level> dimension;
    private ResourceKey<DimensionType> dimensionTypeId;
    private Holder<DimensionType> dimensionTypeRegistration;
    private FakePlayer fakePlayer = null;
    private FakeEntityManager<Entity> fakeEntityManager = null;
    private Creeper chargedCreeper = null;
    private DamageSource playerSource = null;
    private DamageSource chargedCreeperSource = null;

    public static void simulateDrops(WootDropsProperties properties) {
        INSTANCE.simulate(properties);
    }

    @NotNull
    public static ServerLevel getLevel() {
        return DropSimulator.INSTANCE.dimensionLevel;
    }

    @NotNull
    public static RandomSource getRandom() {
        return DropSimulator.INSTANCE.dimensionLevel.m_213780_();
    }

    @NotNull
    public static HolderLookup.Provider getLookupProvider() {
        return DropSimulator.INSTANCE.dimensionLevel.m_9598_();
    }

    @Nullable
    public static LivingEntity loadEntity(WootFactoryMob<?> entity, CompoundTag mobTag) {
        return entity.loadEntity(mobTag, DropSimulator.INSTANCE.dimensionLevel);
    }

    public static void patchDimension(WootDropsProperties properties, boolean restore) {
        ServerLevel dropsLevel;
        ServerLevel level = DropSimulator.INSTANCE.dimensionLevel;
        MinecraftServer server = level.m_7654_();
        if (!restore && (dropsLevel = server.m_129880_(properties.getDimension())) != null) {
            ((LevelMixinAccessor)level).woot$setDimension((ResourceKey<Level>)dropsLevel.m_46472_(), (ResourceKey<DimensionType>)dropsLevel.m_220362_(), (Holder<DimensionType>)dropsLevel.m_204156_());
        } else {
            ((LevelMixinAccessor)level).woot$setDimension(DropSimulator.INSTANCE.dimension, DropSimulator.INSTANCE.dimensionTypeId, DropSimulator.INSTANCE.dimensionTypeRegistration);
        }
    }

    private void simulate(WootDropsProperties properties) {
        LivingEntity livingEntity = properties.getEntity();
        if (livingEntity == null) {
            return;
        }
        ItemStack mainHand = properties.getMainHandItem();
        if (!livingEntity.m_5825_() && properties.isInFire()) {
            livingEntity.m_20254_(1);
            livingEntity.m_7311_(20);
            livingEntity.m_146868_(true);
        }
        this.fakePlayer.m_21008_(InteractionHand.MAIN_HAND, mainHand);
        this.fakePlayer.m_21008_(InteractionHand.OFF_HAND, properties.getOffHandItem());
        this.fakeEntityManager.clearEntityList();
        livingEntity.f_19797_ = 100;
        livingEntity.m_6598_((Player)this.fakePlayer);
        RangedAttribute luckAttribute = (RangedAttribute)Attributes.f_22286_;
        this.fakePlayer.m_21051_((Attribute)luckAttribute).m_22100_(Mth.m_14008_((double)properties.getLuck(), (double)luckAttribute.m_147361_(), (double)luckAttribute.m_147362_()));
        if (livingEntity instanceof EnderDragon) {
            EnderDragon enderDragon = (EnderDragon)livingEntity;
            this.simulateEnderdragon(enderDragon, properties);
            return;
        }
        int i = ForgeHooks.getLootingLevel((Entity)livingEntity, (Entity)this.fakePlayer, (DamageSource)this.playerSource);
        livingEntity.captureDrops(new ArrayList());
        LivingEntityMixin mixin = (LivingEntityMixin)livingEntity;
        mixin.woot$dropFromLootTable(this.playerSource, true);
        mixin.woot$dropCustomDeathLoot(this.playerSource, i, true);
        mixin.woot$dropEquipment();
        mixin.woot$dropExperience();
        Collection eventDrops = livingEntity.captureDrops(null);
        ForgeHooks.onLivingDrops((LivingEntity)livingEntity, (DamageSource)this.playerSource, (Collection)eventDrops, (int)i, (boolean)true);
        eventDrops.forEach(e -> this.dimensionLevel.m_7967_((Entity)e));
        List<ItemStack> drops = properties.getItemDrops();
        int experience = properties.getExperience();
        for (Entity droppedEntity : this.fakeEntityManager.getEntityList()) {
            if (droppedEntity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)droppedEntity;
                drops.add(itemEntity.m_32055_());
                continue;
            }
            if (!(droppedEntity instanceof ExperienceOrb)) continue;
            ExperienceOrb experienceOrb = (ExperienceOrb)droppedEntity;
            experience += experienceOrb.m_20801_();
        }
        properties.setExperience(experience);
        this.fakeEntityManager.clearEntityList();
        if (properties.doSimulateChargedCreeper()) {
            drops.addAll(this.simulateChargedCreeper(livingEntity));
        }
    }

    @NotNull
    private List<ItemStack> simulateChargedCreeper(@NotNull LivingEntity livingEntity) {
        this.fakeEntityManager.clearEntityList();
        livingEntity.f_19797_ = 0;
        livingEntity.m_6598_(null);
        ((CreeperMixin)this.chargedCreeper).woot$setDroppedSkulls(0);
        int i = ForgeHooks.getLootingLevel((Entity)livingEntity, (Entity)this.chargedCreeper, (DamageSource)this.chargedCreeperSource);
        livingEntity.captureDrops(null);
        LivingEntityMixin mixin = (LivingEntityMixin)livingEntity;
        mixin.woot$dropCustomDeathLoot(this.chargedCreeperSource, i, false);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (Entity droppedEntity : this.fakeEntityManager.getEntityList()) {
            if (!(droppedEntity instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)droppedEntity;
            drops.add(itemEntity.m_32055_());
        }
        this.fakeEntityManager.clearEntityList();
        return drops;
    }

    private void simulateEnderdragon(@NotNull EnderDragon enderDragon, WootDropsProperties properties) {
        this.fakeEntityManager.clearEntityList();
        EndDragonFight.Data data = new EndDragonFight.Data(false, false, properties.isEnderDragonAlreadyKilled(), false, Optional.empty(), Optional.empty(), Optional.empty());
        enderDragon.m_287231_((EndDragonFight)new FakeDragonFight(this.dimensionLevel, this.dimensionLevel.m_7328_(), data));
        enderDragon.m_20225_(true);
        EnderDragonMixin dragonMixin = (EnderDragonMixin)enderDragon;
        dragonMixin.woot$setUnlimitedLastHurtByPlayer((Player)this.fakePlayer);
        enderDragon.f_31084_ = 0;
        while (!((EndDragonFightMixin)enderDragon.m_31158_()).woot$getDragonKilled()) {
            dragonMixin.woot$tickDeath();
        }
        int i = ForgeHooks.getLootingLevel((Entity)enderDragon, (Entity)this.fakePlayer, (DamageSource)this.playerSource);
        enderDragon.captureDrops(new ArrayList());
        LivingEntityMixin mixin = (LivingEntityMixin)enderDragon;
        mixin.woot$dropFromLootTable(this.playerSource, true);
        mixin.woot$dropCustomDeathLoot(this.playerSource, i, true);
        mixin.woot$dropEquipment();
        mixin.woot$dropExperience();
        Collection eventDrops = enderDragon.captureDrops(null);
        ForgeHooks.onLivingDrops((LivingEntity)enderDragon, (DamageSource)this.playerSource, (Collection)eventDrops, (int)i, (boolean)true);
        eventDrops.forEach(e -> this.dimensionLevel.m_7967_((Entity)e));
        List<ItemStack> drops = properties.getItemDrops();
        int experience = properties.getExperience();
        for (Entity droppedEntity : this.fakeEntityManager.getEntityList()) {
            if (droppedEntity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)droppedEntity;
                drops.add(itemEntity.m_32055_());
                continue;
            }
            if (!(droppedEntity instanceof ExperienceOrb)) continue;
            ExperienceOrb experienceOrb = (ExperienceOrb)droppedEntity;
            experience += experienceOrb.m_20801_();
        }
        properties.setExperience(experience);
        this.fakeEntityManager.clearEntityList();
    }

    public static void init(ServerLevel dimensionLevel) {
        INSTANCE.setup(dimensionLevel);
    }

    private void setup(ServerLevel dimensionLevel) {
        this.setDimensionLevel(dimensionLevel);
        this.patchDimensionLevel();
        this.initFakePlayer();
        this.initDamageSources();
    }

    private void setDimensionLevel(ServerLevel level) {
        this.dimensionLevel = level;
        this.dimension = level.m_46472_();
        this.dimensionTypeId = level.m_220362_();
        this.dimensionTypeRegistration = level.m_204156_();
    }

    private void initFakePlayer() {
        this.fakePlayer = new FakePlayer(this.dimensionLevel, this.gameProfile);
    }

    private void initDamageSources() {
        DamageSources sources = this.dimensionLevel.m_269111_();
        CompoundTag creeper = new CompoundTag();
        creeper.m_128359_("id", "minecraft:creeper");
        creeper.m_128379_("powered", true);
        this.chargedCreeper = (Creeper)EntityType.m_20645_((CompoundTag)creeper, (Level)this.dimensionLevel, e -> e);
        this.playerSource = sources.m_269075_((Player)this.fakePlayer);
        this.chargedCreeperSource = sources.m_269036_((Entity)this.chargedCreeper, (Entity)this.chargedCreeper);
    }

    private void patchDimensionLevel() {
        ServerLevelMixinAccessor level = (ServerLevelMixinAccessor)this.dimensionLevel;
        PersistentEntitySectionManager<Entity> persistentEntitySectionManager = level.woot$getEntityManager();
        PersistentEntitySectionManagerMixin entitySectionMixin = (PersistentEntitySectionManagerMixin)persistentEntitySectionManager;
        EntityPersistentStorage entityPersistentStorage = entitySectionMixin.woot$getPermanentStorage();
        this.fakeEntityManager = new FakeEntityManager<Entity>(Entity.class, entitySectionMixin.woot$getCallbacks(), entityPersistentStorage);
        level.woot$setEntityManager(this.fakeEntityManager);
    }
}

