/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.events;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.locale.Language;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import wootrevived.api.WootFactoryMob;
import wootrevived.woot.drops.simulator.DropSimulator;
import wootrevived.woot.drops.simulator.DropSimulatorDimension;
import wootrevived.woot.registries.WootFactoryMobsRegistry;

@Mod.EventBusSubscriber(modid="woot_revived")
public class InitDropSimulator {
    public static final List<ResourceLocation> mobLocations = new ArrayList<ResourceLocation>();

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        ServerLevel level = event.getServer().m_129880_(DropSimulatorDimension.DROP_SIMULATOR_LEVEL);
        if (level != null) {
            DropSimulator.init(level);
            mobLocations.clear();
            for (WootFactoryMob<?> mob : List.copyOf(WootFactoryMobsRegistry.getFactoryMobValues())) {
                if (mob.isBlacklisted()) continue;
                EntityType<?> entityType = mob.getEntityType();
                if (!Language.m_128107_().m_6722_(entityType.m_20675_())) {
                    WootFactoryMobsRegistry.removeFactoryMob(entityType);
                    continue;
                }
                try {
                    Entity entity = entityType.m_20615_((Level)level);
                    if (!(entity instanceof LivingEntity)) {
                        WootFactoryMobsRegistry.removeFactoryMob(entityType);
                        continue;
                    }
                    ResourceLocation location = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
                    mobLocations.add(location);
                }
                catch (Exception ignored) {
                    WootFactoryMobsRegistry.removeFactoryMob(entityType);
                }
            }
        }
    }
}

