/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.events;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.locale.Language;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import wootrevived.api.WootFactoryMob;
import wootrevived.woot.items.mob_shard.MobShardItem;
import wootrevived.woot.items.mob_shard.MobShardProjectile;
import wootrevived.woot.registries.WootFactoryMobsRegistry;
import wootrevived.woot.util.helper.SerializeEntityNBTHelper;

@Mod.EventBusSubscriber(modid="woot_revived")
public class MobShardKillCheck {
    private static final List<String> uuidList = new ArrayList<String>();

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player killer = (Player)entity;
        if (killer instanceof FakePlayer) {
            return;
        }
        if (event.getEntity() == null) {
            return;
        }
        if (event.getSource().m_7640_() != null && event.getEntity().m_20148_().equals(event.getSource().m_7640_().m_20148_())) {
            return;
        }
        LivingEntity victim = event.getEntity();
        if (MobShardKillCheck.ignoreDeathEvent((Entity)event.getEntity())) {
            return;
        }
        if (victim instanceof Player) {
            return;
        }
        EntityType entityType = victim.m_6095_();
        if (!Language.m_128107_().m_6722_(entityType.m_20675_())) {
            return;
        }
        if (!WootFactoryMobsRegistry.hasFactoryMob(entityType)) {
            return;
        }
        WootFactoryMob<?> mob = WootFactoryMobsRegistry.getFactoryMob(entityType);
        if (mob.isBlacklisted()) {
            return;
        }
        victim.m_20049_(MobShardProjectile.MOB_SHARD_HAS_BEEN_KILLED);
        if (victim.m_19880_().contains(MobShardProjectile.MOB_SHARD_KILLED_BY_PROJECTILE)) {
            return;
        }
        ItemStack inHandItemStack = killer.m_21205_();
        Item item = inHandItemStack.m_41720_();
        if (item instanceof MobShardItem) {
            MobShardItem mobShardItem = (MobShardItem)item;
            if (!MobShardItem.isProgrammed(inHandItemStack)) {
                mobShardItem.m_7579_(inHandItemStack, victim, (LivingEntity)killer);
            }
        }
        MobShardItem.handleKill(killer, SerializeEntityNBTHelper.serialize((Entity)victim));
    }

    private static boolean ignoreDeathEvent(Entity entity) {
        String uuid = entity.m_20149_();
        if (uuidList.contains(uuid)) {
            return true;
        }
        uuidList.add(uuid);
        int MAX_UUID_CACHE_SIZE = 10;
        if (uuidList.size() > MAX_UUID_CACHE_SIZE) {
            uuidList.remove(0);
        }
        return false;
    }
}

