/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.events;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import wootrevived.woot.multiblock.MultiBlockFactoryEntity;
import wootrevived.woot.multiblock.patterns.Patterns;

@Mod.EventBusSubscriber(modid="woot_revived")
public class MultiBlockUpdate {
    @SubscribeEvent
    public static void onEntityPlace(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor accessor = event.getLevel();
        if (accessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)accessor;
            BlockState state = event.getPlacedBlock();
            if (Patterns.getValidBlocks().contains(state.m_60734_())) {
                MultiBlockUpdate.updateMultiblocksPattern(level, List.of(event.getPos()));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityBreak(BlockEvent.BreakEvent event) {
        LevelAccessor accessor = event.getLevel();
        if (accessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)accessor;
            BlockState state = event.getState();
            if (Patterns.getValidBlocks().contains(state.m_60734_())) {
                level.m_7654_().execute(() -> MultiBlockUpdate.updateMultiblocksPattern(level, List.of(event.getPos())));
            }
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkWatchEvent.Watch event) {
        ServerLevel level = event.getLevel();
        for (BlockEntity be : event.getChunk().m_62954_().values()) {
            if (!(be instanceof MultiBlockFactoryEntity)) continue;
            MultiBlockFactoryEntity entity = (MultiBlockFactoryEntity)be;
            entity.updatePattern((Level)level);
        }
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            List<BlockPos> validBlocks = event.getAffectedBlocks().stream().filter(pos -> Patterns.getValidBlocks().contains(level2.m_8055_(pos).m_60734_())).toList();
            if (!validBlocks.isEmpty()) {
                level2.m_7654_().m_6937_((Runnable)new TickTask(level2.m_7654_().m_129921_() + 1, () -> MultiBlockUpdate.updateMultiblocksPattern(level2, validBlocks)));
            }
        }
    }

    private static void updateMultiblocksPattern(ServerLevel level, List<BlockPos> positions) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (BlockPos pos : positions) {
            AABB area = Patterns.getSearchAABB(pos);
            if (minX > area.f_82288_) {
                minX = area.f_82288_;
            }
            if (minY > area.f_82289_) {
                minY = area.f_82289_;
            }
            if (minZ > area.f_82290_) {
                minZ = area.f_82290_;
            }
            if (maxX < area.f_82291_) {
                maxX = area.f_82291_;
            }
            if (maxY < area.f_82292_) {
                maxY = area.f_82292_;
            }
            if (!(maxZ < area.f_82293_)) continue;
            maxZ = area.f_82293_;
        }
        int minSectionX = SectionPos.m_235865_((double)minX);
        int minSectionZ = SectionPos.m_235865_((double)minZ);
        int maxSectionX = SectionPos.m_235865_((double)maxX);
        int maxSectionZ = SectionPos.m_235865_((double)maxZ);
        for (int sectionX = minSectionX; sectionX <= maxSectionX; ++sectionX) {
            for (int sectionZ = minSectionZ; sectionZ <= maxSectionZ; ++sectionZ) {
                LevelChunk chunk = level.m_6325_(sectionX, sectionZ);
                for (BlockPos entityPos : chunk.m_5928_()) {
                    BlockEntity entity;
                    if (!(minX <= (double)entityPos.m_123341_()) || !(minY <= (double)entityPos.m_123342_()) || !(minZ <= (double)entityPos.m_123343_()) || !(maxX >= (double)entityPos.m_123341_()) || !(maxY >= (double)entityPos.m_123342_()) || !(maxZ >= (double)entityPos.m_123343_()) || !((entity = chunk.m_7702_(entityPos)) instanceof MultiBlockFactoryEntity)) continue;
                    MultiBlockFactoryEntity multiblock = (MultiBlockFactoryEntity)entity;
                    multiblock.updatePattern((Level)level);
                }
            }
        }
    }
}

