/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.events.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.locale.Language;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import wootrevived.api.WootFactoryMob;
import wootrevived.woot.registries.WootFactoryMobsRegistry;

@Mod.EventBusSubscriber(modid="woot_revived", value={Dist.CLIENT})
public class GuideCacheLivingEntities {
    private static final Map<EntityType<?>, LivingEntity> livingEntities = new HashMap();

    public static Map<EntityType<?>, LivingEntity> getLivingEntities() {
        return livingEntities;
    }

    @SubscribeEvent
    public static void onClientLoggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        LocalPlayer player = event.getPlayer();
        Level level = player.m_9236_();
        livingEntities.clear();
        for (WootFactoryMob<?> mob : List.copyOf(WootFactoryMobsRegistry.getFactoryMobValues())) {
            if (mob.isBlacklisted()) continue;
            EntityType<?> entityType = mob.getEntityType();
            if (!Language.m_128107_().m_6722_(entityType.m_20675_())) {
                WootFactoryMobsRegistry.removeFactoryMob(entityType);
                continue;
            }
            try {
                Entity entity = entityType.m_20615_(level);
                if (!(entity instanceof LivingEntity)) {
                    WootFactoryMobsRegistry.removeFactoryMob(entityType);
                    continue;
                }
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntities.put(entityType, livingEntity);
            }
            catch (Exception ignored) {
                WootFactoryMobsRegistry.removeFactoryMob(entityType);
            }
        }
    }
}

