/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.guide;

import guideme.compiler.PageCompiler;
import guideme.compiler.tags.BlockTagCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.LytErrorSink;
import guideme.document.block.LytBlock;
import guideme.document.block.LytBlockContainer;
import guideme.document.block.LytHBox;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.scene.level.GuidebookLevel;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.enums.Tier;
import wootrevived.woot.events.client.GuideCacheLivingEntities;
import wootrevived.woot.registries.WootFactoryMobsRegistry;
import wootrevived.woot.util.render.guide.LytEntity;

public class TierMobsCompiler
extends BlockTagCompiler {
    public Set<String> getTagNames() {
        return Set.of("TierMobs");
    }

    protected void compile(PageCompiler compiler, LytBlockContainer parent, MdxJsxElementFields el) {
        Tier tier = (Tier)MdxAttrs.getEnum((PageCompiler)compiler, (LytErrorSink)parent, (MdxJsxElementFields)el, (String)"tier", (Enum)Tier.TIER_1);
        Map<EntityType<?>, LivingEntity> cachedLivingEntities = GuideCacheLivingEntities.getLivingEntities();
        ArrayList mobs = new ArrayList();
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        for (WootFactoryMob<?> mob : WootFactoryMobsRegistry.getFactoryMobValues()) {
            EntityType<?> entityType;
            if (mob.getTier() != tier || !cachedLivingEntities.containsKey(entityType = mob.getEntityType())) continue;
            mobs.add(mob);
            entities.add(cachedLivingEntities.get(mob.getEntityType()));
        }
        GuidebookLevel level = new GuidebookLevel();
        LytHBox box = new LytHBox();
        for (int i = 0; i < mobs.size(); ++i) {
            box.append((LytBlock)new LytEntity((WootFactoryMob)mobs.get(i), (LivingEntity)entities.get(i), level));
        }
        parent.append((LytBlock)box);
    }
}

