/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.guide.recipes;

import guideme.document.LytRect;
import guideme.document.block.LytBlock;
import guideme.document.block.LytBox;
import guideme.document.block.LytSlot;
import guideme.layout.LayoutContext;
import guideme.render.RenderContext;
import java.util.ArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import wootrevived.woot.config.EnchantedLiquifierConfig;
import wootrevived.woot.registries.FluidsRegistry;
import wootrevived.woot.util.render.WootContainerScreen;
import wootrevived.woot.util.render.guide.LytEnergy;
import wootrevived.woot.util.render.guide.LytFluid;

public class LytEnchantedLiquifierRecipe
extends LytBox {
    private static final int GUI_WIDTH = 95;
    private static final int GUI_HEIGHT = 66;
    private static final int ENERGY_X = 5;
    private static final int ENERGY_Y = 5;
    private static final int INPUT_SLOT_X = 26;
    private static final int INPUT_SLOT_Y = 24;
    private static final int OUTPUT_FLUID_X = 72;
    private static final int OUTPUT_FLUID_Y = 5;
    private static final int PROGRESS_X = 47;
    private static final int PROGRESS_Y = 25;
    private final LytEnergy energy;
    private final LytSlot inputSlot;
    private final LytFluid outputFluid;

    public LytEnchantedLiquifierRecipe(int enchantLevel) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS.getValues()) {
            if (enchantLevel > enchantment.m_6586_() || enchantLevel < enchantment.m_44702_()) continue;
            ItemStack itemStack = Items.f_42690_.m_7968_();
            itemStack.m_41663_(enchantment, enchantLevel);
            items.add(itemStack);
        }
        int energyAmount = enchantLevel * (Integer)EnchantedLiquifierConfig.PER_ENCHANT_ENERGY.get();
        int fluidAmount = enchantLevel * (Integer)EnchantedLiquifierConfig.PER_ENCHANT_FLUID.get();
        this.energy = new LytEnergy(energyAmount, (Integer)EnchantedLiquifierConfig.ENERGY_CAPACITY.get());
        this.append(this.energy);
        this.inputSlot = new LytSlot(Ingredient.m_43921_(items.stream()));
        this.append((LytBlock)this.inputSlot);
        this.outputFluid = new LytFluid(new FluidStack((Fluid)FluidsRegistry.SOURCE_ENCHANTED_FLUID.get(), fluidAmount), (Integer)EnchantedLiquifierConfig.OUTPUT_TANK_CAPACITY.get());
        this.append(this.outputFluid);
    }

    protected LytRect computeBoxLayout(LayoutContext context, int x, int y, int availableWidth) {
        this.energy.layout(context, x + 5, y + 5, availableWidth);
        this.inputSlot.layout(context, x + 26, y + 24, availableWidth);
        this.outputFluid.layout(context, x + 72, y + 5, availableWidth);
        return new LytRect(x, y, 95, 66);
    }

    public void render(RenderContext context) {
        context.renderPanel(this.bounds);
        WootContainerScreen.renderProgressArrowBg(context.guiGraphics(), this.bounds.x() + 47, this.bounds.y() + 25);
        super.render(context);
    }
}

