/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.guide.recipes;

import guideme.document.LytRect;
import guideme.document.block.LytBlock;
import guideme.document.block.LytBox;
import guideme.document.block.LytSlot;
import guideme.layout.LayoutContext;
import guideme.render.RenderContext;
import net.minecraft.world.item.crafting.Ingredient;
import wootrevived.woot.config.ItemInfuserConfig;
import wootrevived.woot.recipes.item_infuser.ItemInfuserRecipe;
import wootrevived.woot.util.render.WootContainerScreen;
import wootrevived.woot.util.render.guide.LytEnergy;
import wootrevived.woot.util.render.guide.LytFluid;

public class LytItemInfuserRecipe
extends LytBox {
    private static final int GUI_WIDTH = 134;
    private static final int GUI_HEIGHT = 66;
    private static final int ENERGY_X = 5;
    private static final int ENERGY_Y = 5;
    private static final int INPUT_FLUID_X = 26;
    private static final int INPUT_FLUID_Y = 5;
    private static final int INGREDIENT_SLOT_X = 47;
    private static final int INGREDIENT_SLOT_Y = 24;
    private static final int AUGMENT_SLOT_X = 65;
    private static final int AUGMENT_SLOT_Y = 24;
    private static final int OUTPUT_SLOT_X = 111;
    private static final int OUTPUT_SLOT_Y = 24;
    private static final int PROGRESS_X = 86;
    private static final int PROGRESS_Y = 25;
    private final LytEnergy energy;
    private final LytFluid inputFluid;
    private final LytSlot ingredientSlot;
    private final LytSlot augmentSlot;
    private final LytSlot outputSlot;

    public LytItemInfuserRecipe(ItemInfuserRecipe recipe) {
        this.energy = new LytEnergy(recipe.getEnergy(), (Integer)ItemInfuserConfig.ENERGY_CAPACITY.get());
        this.append(this.energy);
        this.inputFluid = new LytFluid(recipe.getFluid(), (Integer)ItemInfuserConfig.INPUT_TANK_CAPACITY.get());
        this.append(this.inputFluid);
        this.ingredientSlot = new LytSlot(recipe.getIngredient());
        this.append((LytBlock)this.ingredientSlot);
        this.augmentSlot = new LytSlot(recipe.getAugment().orElse(Ingredient.m_151265_()));
        this.append((LytBlock)this.augmentSlot);
        this.outputSlot = new LytSlot(recipe.getOutput());
        this.append((LytBlock)this.outputSlot);
    }

    protected LytRect computeBoxLayout(LayoutContext context, int x, int y, int availableWidth) {
        this.energy.layout(context, x + 5, y + 5, availableWidth);
        this.inputFluid.layout(context, x + 26, y + 5, availableWidth);
        this.ingredientSlot.layout(context, x + 47, y + 24, availableWidth);
        this.augmentSlot.layout(context, x + 65, y + 24, availableWidth);
        this.outputSlot.layout(context, x + 111, y + 24, availableWidth);
        return new LytRect(x, y, 134, 66);
    }

    public void render(RenderContext context) {
        context.renderPanel(this.bounds);
        WootContainerScreen.renderProgressArrowBg(context.guiGraphics(), this.bounds.x() + 86, this.bounds.y() + 25);
        super.render(context);
    }
}

