/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.init;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;
import wootrevived.api.IWootPlugin;
import wootrevived.api.WootPlugin;
import wootrevived.api.registrations.WootFactoryMobRegistration;
import wootrevived.api.registrations.WootUpgradeItemRegistration;
import wootrevived.woot.compat.kubejs.WootStartupEvents;
import wootrevived.woot.init.WootRevivedPlugin;

public class WootPlugins {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final WootRevivedPlugin wootInternalPlugin = new WootRevivedPlugin();
    private static List<IWootPlugin> plugins;

    public static void registerPlugins() {
        plugins = WootPlugins.getInstances(WootPlugin.class, IWootPlugin.class);
    }

    public static void registerUpgradeItems(WootUpgradeItemRegistration registration) {
        wootInternalPlugin.registerUpgradeItems(registration);
        for (IWootPlugin plugin : plugins) {
            plugin.registerUpgradeItems(registration);
        }
    }

    public static void registerFactoryMobs(WootFactoryMobRegistration registration) {
        wootInternalPlugin.registerFactoryMobs(registration);
        for (IWootPlugin plugin : plugins) {
            plugin.registerFactoryMobs(registration);
        }
        if (ModList.get().isLoaded("kubejs")) {
            WootStartupEvents.postFactoryMobs(registration);
        }
    }

    private static <T> List<T> getInstances(Class<?> annotationClass, Class<T> instanceClass) {
        Type annotationType = Type.getType(annotationClass);
        List allScanData = ModList.get().getAllScanData();
        LinkedHashSet<String> pluginClassNames = new LinkedHashSet<String>();
        for (ModFileScanData scanData : allScanData) {
            Set annotations = scanData.getAnnotations();
            for (ModFileScanData.AnnotationData annotation : annotations) {
                if (!Objects.equals(annotation.annotationType(), annotationType)) continue;
                String memberName = annotation.memberName();
                pluginClassNames.add(memberName);
            }
        }
        ArrayList<T> instances = new ArrayList<T>();
        for (String pluginClassName : pluginClassNames) {
            try {
                Class<?> asmClass = Class.forName(pluginClassName);
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                Constructor<T> constructor = asmInstanceClass.getDeclaredConstructor(new Class[0]);
                T instance = constructor.newInstance(new Object[0]);
                instances.add(instance);
            }
            catch (LinkageError | ReflectiveOperationException e) {
                LOGGER.error("Failed to load: {}", (Object)pluginClassName, (Object)e);
            }
        }
        return instances;
    }
}

