/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.items.mob_shard;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.WootFactoryMob;
import wootrevived.woot.config.MobShardConfig;
import wootrevived.woot.items.mob_shard.MobShardProjectile;
import wootrevived.woot.registries.ItemsRegistry;
import wootrevived.woot.registries.WootFactoryMobsRegistry;
import wootrevived.woot.util.helper.ModNameHelper;
import wootrevived.woot.util.helper.SerializeEntityNBTHelper;
import wootrevived.woot.util.render.WootStyles;

public class MobShardItem
extends Item {
    public MobShardItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public boolean m_7579_(@NotNull ItemStack stack, @NotNull LivingEntity target, LivingEntity tmpAttacker) {
        if (tmpAttacker.m_20193_().m_5776_() || !(tmpAttacker instanceof Player)) {
            return false;
        }
        Player attacker = (Player)tmpAttacker;
        if (!WootFactoryMobsRegistry.hasFactoryMob(target.m_6095_())) {
            return false;
        }
        WootFactoryMob<?> mob = WootFactoryMobsRegistry.getFactoryMob(target.m_6095_());
        if (mob.isBlacklisted()) {
            return false;
        }
        if (MobShardItem.isProgrammed(stack)) {
            return false;
        }
        return this.setProgrammedMob(stack, mob.saveTag(SerializeEntityNBTHelper.serialize((Entity)target), (HolderLookup.Provider)target.m_9236_().m_9598_()));
    }

    public static boolean isProgrammed(ItemStack itemStack) {
        return itemStack.m_41784_().m_128441_("Mob");
    }

    public static CompoundTag getProgrammedMob(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        if (tag.m_128441_("Mob")) {
            return tag.m_128469_("Mob");
        }
        return null;
    }

    private boolean setProgrammedMob(ItemStack itemStack, CompoundTag mobTag) {
        if (!WootFactoryMobsRegistry.hasFactoryMob(mobTag)) {
            return false;
        }
        CompoundTag stackTag = itemStack.m_41784_();
        stackTag.m_128365_("Mob", (Tag)mobTag);
        stackTag.m_128405_("Kills", 0);
        return true;
    }

    private static boolean isMatchingMob(ItemStack itemStack, CompoundTag mobTag, Level level) {
        if (itemStack.m_41720_() != ItemsRegistry.MOB_SHARD_ITEM.get()) {
            return false;
        }
        if (!MobShardItem.isProgrammed(itemStack)) {
            return false;
        }
        CompoundTag programmedMob = MobShardItem.getProgrammedMob(itemStack);
        if (programmedMob == null) {
            return false;
        }
        WootFactoryMob<?> mob = WootFactoryMobsRegistry.getFactoryMob(programmedMob);
        return mob.isSame(programmedMob, mobTag, (HolderLookup.Provider)level.m_9598_());
    }

    public static void handleKill(Player player, CompoundTag mobTag) {
        ItemStack foundStack = ItemStack.f_41583_;
        ItemStack inHandItemStack = player.m_21205_();
        if (!inHandItemStack.m_41619_() && MobShardItem.isMatchingMob(inHandItemStack, mobTag, player.m_9236_()) && !MobShardItem.isFullyProgrammed(inHandItemStack)) {
            foundStack = inHandItemStack;
        } else {
            ArrayList inventoryItems = new ArrayList();
            inventoryItems.addAll(player.m_150109_().f_35976_);
            inventoryItems.addAll(player.m_150109_().f_35974_);
            for (ItemStack itemStack : inventoryItems) {
                if (inHandItemStack.equals(itemStack) || itemStack.m_41619_() || !MobShardItem.isMatchingMob(itemStack, mobTag, player.m_9236_()) || MobShardItem.isFullyProgrammed(itemStack)) continue;
                foundStack = itemStack;
                break;
            }
        }
        if (!foundStack.m_41619_()) {
            MobShardItem.incrementKills(foundStack, 1);
        }
    }

    public static void incrementKills(ItemStack itemStack, int amount) {
        if (itemStack.m_41720_() != ItemsRegistry.MOB_SHARD_ITEM.get()) {
            return;
        }
        CompoundTag mobTag = MobShardItem.getProgrammedMob(itemStack);
        if (mobTag == null) {
            return;
        }
        int killCount = itemStack.m_41784_().m_128451_("Kills");
        if (!MobShardItem.isFull(itemStack)) {
            itemStack.m_41784_().m_128405_("Kills", killCount += amount);
        }
    }

    private static boolean isFull(ItemStack itemStack) {
        int killCount = itemStack.m_41784_().m_128451_("Kills");
        CompoundTag mobTag = MobShardItem.getProgrammedMob(itemStack);
        if (mobTag == null) {
            return false;
        }
        return killCount >= (Integer)MobShardConfig.NUM_OF_KILLS.get();
    }

    public static void setJEIShard(ItemStack itemStack) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("nbt_jei_shard", 1);
        itemStack.m_41751_(tag);
    }

    public static boolean isJEIShard(ItemStack itemStack) {
        return itemStack.m_41784_().m_128441_("nbt_jei_shard");
    }

    public static boolean isFullyProgrammed(ItemStack itemStack) {
        return MobShardItem.isProgrammed(itemStack) && MobShardItem.isFull(itemStack);
    }

    public boolean m_5812_(@NotNull ItemStack itemStack) {
        if (MobShardItem.isFullyProgrammed(itemStack)) {
            return true;
        }
        return MobShardItem.isJEIShard(itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        WootFactoryMob<?> mob;
        super.m_7373_(stack, level, tooltip, flag);
        if (MobShardItem.isJEIShard(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"info.woot_revived.mobshard.programmed").m_6270_(WootStyles.SHARD_PROGRAM_STYLE));
            return;
        }
        CompoundTag mobTag = MobShardItem.getProgrammedMob(stack);
        if (mobTag == null) {
            tooltip.add((Component)Component.m_237115_((String)"info.woot_revived.mobshard.unprogrammed").m_6270_(WootStyles.SHARD_PROGRAM_STYLE));
            tooltip.add((Component)Component.m_237115_((String)"info.woot_revived.mobshard.unprogrammed.desc").m_6270_(WootStyles.DESCRIPTION_STYLE));
            return;
        }
        if (level == null) {
            level = Minecraft.m_91087_().f_91073_;
        }
        if ((mob = WootFactoryMobsRegistry.getFactoryMob(mobTag)) != null) {
            tooltip.add((Component)mob.getDisplayName(mobTag, (HolderLookup.Provider)level.m_9598_()).m_6270_(WootStyles.CAPTURED_STYLE));
            String modId = ForgeRegistries.ENTITY_TYPES.getKey(mob.getEntityType()).m_135827_();
            tooltip.add((Component)ModNameHelper.getModName(modId).m_6270_(WootStyles.MOD_NAME_STYLE));
        }
        int killCount = stack.m_41784_().m_128451_("Kills");
        if (MobShardItem.isFull(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"info.woot_revived.mobshard.programmed").m_6270_(WootStyles.SHARD_PROGRAM_STYLE));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"info.woot_revived.mobshard.remaining", (Object[])new Object[]{killCount, MobShardConfig.NUM_OF_KILLS.get()}).m_6270_(WootStyles.SHARD_PROGRAM_STYLE));
            if (mob != null) {
                tooltip.add((Component)Component.m_237110_((String)"info.woot_revived.mobshard.remaining.desc", (Object[])new Object[]{mob.getTooltipKillName(mobTag, (HolderLookup.Provider)level.m_9598_()).m_6270_(WootStyles.DESCRIPTION_STYLE)}).m_6270_(WootStyles.DESCRIPTION_STYLE));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"info.woot_revived.mobshard.remaining.desc_no_entity").m_6270_(WootStyles.DESCRIPTION_STYLE));
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        if (MobShardItem.isProgrammed(itemStack)) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        player.m_6672_(usedHand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity, int timeLeft) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int used = this.m_8105_(stack) - timeLeft;
        float pull = Math.min((float)used / 20.0f, 1.0f);
        MobShardProjectile proj = new MobShardProjectile(player, level);
        proj.m_37446_(stack);
        proj.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, pull * 2.0f, 1.0f - pull * 0.5f);
        if (!level.f_46443_) {
            level.m_7967_((Entity)proj);
        }
        stack.m_41774_(1);
    }
}

