/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.items.mob_shard;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.items.mob_shard.MobShardItem;
import wootrevived.woot.items.mob_shard.MobShardItemEntity;
import wootrevived.woot.registries.ItemsRegistry;

public class MobShardProjectile
extends ThrowableItemProjectile {
    public static String MOB_SHARD_KILLED_BY_PROJECTILE = "MOB_SHARD_KILLED_BY_PROJECTILE";
    public static String MOB_SHARD_HAS_BEEN_KILLED = "MOB_SHARD_HAS_BEEN_KILLED";

    public MobShardProjectile(EntityType<MobShardProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public MobShardProjectile(Player player, Level level) {
        super((EntityType)ItemsRegistry.MOB_SHARD_PROJECTILE.get(), (LivingEntity)player, level);
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ItemsRegistry.MOB_SHARD_ITEM.get();
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 vec3 = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = vec3.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        if (this.m_20077_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_8060_(@NotNull BlockHitResult result) {
        if (!this.m_9236_().f_46443_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            BlockPos pos = result.m_82425_();
            this.dropItem(this.m_7846_(), pos);
        }
        super.m_8060_(result);
    }

    protected void m_5790_(@NotNull EntityHitResult result) {
        super.m_5790_(result);
        if (!this.m_9236_().f_46443_) {
            Entity target = result.m_82443_();
            Entity shooter = this.m_19749_();
            ItemStack itemStack = this.m_7846_();
            if (shooter instanceof Player) {
                Player player = (Player)shooter;
                Entity realTarget = target;
                while (realTarget instanceof PartEntity) {
                    PartEntity partEntity = (PartEntity)realTarget;
                    realTarget = partEntity.getParent();
                }
                DamageSources sources = new DamageSources(this.m_9236_().m_9598_());
                realTarget.m_20049_(MOB_SHARD_KILLED_BY_PROJECTILE);
                target.m_6469_(sources.m_269075_(player), 1.0f);
                if (realTarget instanceof Mob) {
                    Mob mob = (Mob)realTarget;
                    Item item = itemStack.m_41720_();
                    item.m_7579_(itemStack, (LivingEntity)mob, (LivingEntity)player);
                    if (realTarget.m_19880_().contains(MOB_SHARD_HAS_BEEN_KILLED)) {
                        realTarget.m_20137_(MOB_SHARD_HAS_BEEN_KILLED);
                        MobShardItem.incrementKills(itemStack, 1);
                    }
                }
                realTarget.m_20137_(MOB_SHARD_KILLED_BY_PROJECTILE);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            BlockPos pos = result.m_82443_().m_20097_();
            this.dropItem(itemStack, pos);
        }
    }

    private void dropItem(ItemStack itemStack, BlockPos pos) {
        Level level = this.m_9236_();
        if (level.f_46443_) {
            return;
        }
        if (level.m_8055_(pos.m_7494_()).m_60795_()) {
            pos = pos.m_7494_();
        } else if (level.m_8055_(pos.m_7495_()).m_60795_()) {
            pos = pos.m_7495_();
        } else if (level.m_8055_(pos.m_122029_()).m_60795_()) {
            pos = pos.m_122029_();
        } else if (level.m_8055_(pos.m_122024_()).m_60795_()) {
            pos = pos.m_122024_();
        } else if (level.m_8055_(pos.m_122012_()).m_60795_()) {
            pos = pos.m_122012_();
        } else if (level.m_8055_(pos.m_122019_()).m_60795_()) {
            pos = pos.m_122019_();
        }
        double x = pos.m_123341_();
        double y = pos.m_123342_();
        double z = pos.m_123343_();
        double d0 = EntityType.f_20461_.m_20678_();
        double d1 = 1.0 - d0;
        double d2 = d0 / 2.0;
        double d3 = Math.floor(x) + level.f_46441_.m_188500_() * d1 + d2;
        double d4 = Math.floor(y) + level.f_46441_.m_188500_() * d1;
        double d5 = Math.floor(z) + level.f_46441_.m_188500_() * d1 + d2;
        while (!itemStack.m_41619_()) {
            MobShardItemEntity itementity = new MobShardItemEntity(level, d3, d4, d5, itemStack.m_41620_(level.f_46441_.m_188503_(21) + 10));
            itementity.m_20334_(level.f_46441_.m_216328_(0.0, 0.11485000171139836), level.f_46441_.m_216328_(0.2, 0.11485000171139836), level.f_46441_.m_216328_(0.0, 0.11485000171139836));
            level.m_7967_((Entity)itementity);
        }
    }
}

