/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.items.xp;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.registries.ItemsRegistry;
import wootrevived.woot.util.render.WootStyles;

public class XpItem
extends Item {
    private static final int STACK_SIZE = 64;
    public static final int SPLINTERS_IN_STACK = 9;
    private static final int SHARD_XP = 9;
    private static final int SPLINTER_XP = 1;
    final Variant variant;

    public XpItem(Variant variant) {
        super(new Item.Properties().m_41487_(64));
        this.variant = variant;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public static ItemStack getItemStack(Variant variant) {
        if (variant == Variant.SHARD) {
            return ((XpItem)((Object)ItemsRegistry.XP_SHARD_ITEM.get())).m_7968_();
        }
        return ((XpItem)((Object)ItemsRegistry.XP_SPLINTER_ITEM.get())).m_7968_();
    }

    public static List<ItemStack> getShards(int xp) {
        ArrayList<ItemStack> shards = new ArrayList<ItemStack>();
        int xpShards = xp / 9;
        int xpSplinters = xp % 9;
        int fullStacks = xpShards / 64;
        int leftoverShard = xpShards % 64;
        for (int i = 0; i < fullStacks; ++i) {
            ItemStack itemStack = XpItem.getItemStack(Variant.SHARD);
            itemStack.m_41764_(64);
            shards.add(itemStack);
        }
        if (leftoverShard > 0) {
            ItemStack itemStack = XpItem.getItemStack(Variant.SHARD);
            itemStack.m_41764_(leftoverShard);
            shards.add(itemStack);
        }
        if (xpSplinters > 0) {
            ItemStack itemStack = XpItem.getItemStack(Variant.SPLINTER);
            itemStack.m_41764_(xpSplinters);
            shards.add(itemStack);
        }
        return shards;
    }

    private int getXp(ItemStack itemStack) {
        if (itemStack.m_41720_() == ItemsRegistry.XP_SHARD_ITEM.get()) {
            return 9;
        }
        if (itemStack.m_41720_() == ItemsRegistry.XP_SPLINTER_ITEM.get()) {
            return 1;
        }
        return 0;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(usedHand));
        }
        ItemStack itemStack = player.m_21120_(usedHand);
        if (itemStack.m_41619_()) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(usedHand));
        }
        ItemStack advancementStack = itemStack.m_41777_();
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.2f, 0.5f * ((level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.7f + 1.8f));
        if (player instanceof FakePlayer) {
            level.m_7967_((Entity)new ExperienceOrb(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1));
            itemStack.m_41774_(1);
        } else {
            int xp = 0;
            if (player.m_6144_()) {
                xp = this.getXp(itemStack) * itemStack.m_41613_();
                if (!player.m_7500_()) {
                    itemStack.m_41764_(0);
                }
            } else {
                xp = this.getXp(itemStack);
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
            }
            if (xp > 0) {
                player.f_36101_ = 0;
                ExperienceOrb orb = new ExperienceOrb(level, 0.0, 0.0, 0.0, xp);
                orb.m_6123_(player);
                player.f_36101_ = 0;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10592_.m_23682_(serverPlayer, advancementStack);
                }
            }
        }
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"info.woot_revived.shard.0").m_6270_(WootStyles.DESCRIPTION_STYLE));
        tooltip.add((Component)Component.m_237115_((String)"info.woot_revived.shard.1").m_6270_(WootStyles.DESCRIPTION_STYLE));
    }

    public static enum Variant {
        SHARD,
        SPLINTER;

    }
}

