/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.multiblock;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.enums.Tier;
import wootrevived.woot.multiblock.MultiBlockFactory;
import wootrevived.woot.util.common.WootTier;

public abstract class MultiBlockFactoryEntity
extends BlockEntity
implements BlockEntityTicker<BlockEntity> {
    protected Tier tier = Tier.INVALID;

    public MultiBlockFactoryEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof MultiBlockFactoryEntity) {
            MultiBlockFactoryEntity multiBlockFactoryEntity = (MultiBlockFactoryEntity)blockEntity;
            multiBlockFactoryEntity.m_155252_(level, pos, state, blockEntity);
        }
    }

    public void updatePattern(Level level) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        Tier newTier = MultiBlockFactory.updatePattern(level, this.m_58899_(), facing);
        if (newTier != this.tier) {
            this.tier = newTier;
            this.m_6596_();
        }
    }

    public Tier getFactoryTier() {
        return this.tier;
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Tier", this.tier.ordinal());
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.tier = WootTier.byIndex(tag.m_128451_("Tier"));
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

