/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.multiblock.patterns;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import wootrevived.woot.multiblock.patterns.Pattern;
import wootrevived.woot.multiblock.patterns.Tier1;
import wootrevived.woot.multiblock.patterns.Tier2;
import wootrevived.woot.multiblock.patterns.Tier3;
import wootrevived.woot.multiblock.patterns.Tier4;
import wootrevived.woot.multiblock.patterns.Tier5;
import wootrevived.woot.registries.BlocksRegistry;

public class Patterns {
    public static Pattern TIER_1 = new Tier1();
    public static Pattern TIER_2 = new Tier2();
    public static Pattern TIER_3 = new Tier3();
    public static Pattern TIER_4 = new Tier4();
    public static Pattern TIER_5 = new Tier5();
    private static final Map<Direction, List<Pattern.PatternBlock>> fakeSpawnersBlocks = Patterns.generateDirectionalBlocks((Block)BlocksRegistry.FAKE_SPAWNER_BLOCK.get());
    private static final Map<Direction, List<Pattern.PatternBlock>> upgradeBlocks = Patterns.generateDirectionalBlocks((Block)BlocksRegistry.FACTORY_UPGRADE_BLOCK.get());
    private static final Map<Direction, List<Pattern.PatternBlock>> importBlocks = Patterns.generateDirectionalBlocks((Block)BlocksRegistry.IMPORT_BLOCK.get());
    private static final Map<Direction, List<Pattern.PatternBlock>> exportBlocks = Patterns.generateDirectionalBlocks((Block)BlocksRegistry.EXPORT_BLOCK.get());
    private static final Map<Direction, List<Pattern.PatternBlock>> cellBlocks = Patterns.generateDirectionalBlocks((Block)BlocksRegistry.COPPER_CELL_BLOCK.get());
    private static final List<Block> validBlocks = Patterns.generateValidBlocks();
    private static final int width = Patterns.generateLength(Vec3i::m_123341_);
    private static final int height = Patterns.generateLength(Vec3i::m_123342_);
    private static final int depth = Patterns.generateLength(Vec3i::m_123343_);

    public static List<Pattern.PatternBlock> getFakeSpawnersBlocks(Direction facing) {
        return fakeSpawnersBlocks.get(facing);
    }

    public static List<Pattern.PatternBlock> getUpgradeBlocks(Direction facing) {
        return upgradeBlocks.get(facing);
    }

    public static Pattern.PatternBlock getImportBlock(Direction facing) {
        return importBlocks.get(facing).get(0);
    }

    public static Pattern.PatternBlock getExportBlock(Direction facing) {
        return exportBlocks.get(facing).get(0);
    }

    public static Pattern.PatternBlock getCellBlock(Direction facing) {
        return cellBlocks.get(facing).get(0);
    }

    private static Map<Direction, List<Pattern.PatternBlock>> generateDirectionalBlocks(Block block) {
        EnumMap fakeSpawners = Maps.newEnumMap(Direction.class);
        for (Direction direction : Direction.values()) {
            if (direction == Direction.UP || direction == Direction.DOWN) continue;
            fakeSpawners.put(direction, Patterns.getBlocks(direction, block));
        }
        return fakeSpawners;
    }

    public static List<Block> getValidBlocks() {
        return validBlocks;
    }

    private static List<Block> generateValidBlocks() {
        ArrayList<Block> validBlocks = new ArrayList<Block>();
        Patterns.getValidBlocksForPattern(validBlocks, TIER_1);
        Patterns.getValidBlocksForPattern(validBlocks, TIER_2);
        Patterns.getValidBlocksForPattern(validBlocks, TIER_3);
        Patterns.getValidBlocksForPattern(validBlocks, TIER_4);
        Patterns.getValidBlocksForPattern(validBlocks, TIER_5);
        return validBlocks;
    }

    private static void getValidBlocksForPattern(List<Block> blocks, Pattern pattern) {
        for (Pattern.PatternBlock patternBlock : pattern.patterns.get(Direction.NORTH)) {
            for (Block block : patternBlock.blocks) {
                if (block == Blocks.f_50016_ || blocks.contains(block)) continue;
                blocks.add(block);
            }
        }
    }

    private static List<Pattern.PatternBlock> getBlocks(Direction direction, Block block) {
        ArrayList<Pattern.PatternBlock> blocks = new ArrayList<Pattern.PatternBlock>();
        Patterns.getBlocksForPattern(blocks, TIER_1, direction, block);
        Patterns.getBlocksForPattern(blocks, TIER_2, direction, block);
        Patterns.getBlocksForPattern(blocks, TIER_3, direction, block);
        Patterns.getBlocksForPattern(blocks, TIER_4, direction, block);
        Patterns.getBlocksForPattern(blocks, TIER_5, direction, block);
        return blocks;
    }

    private static void getBlocksForPattern(List<Pattern.PatternBlock> blocks, Pattern pattern, Direction direction, Block block) {
        block0: for (Pattern.PatternBlock patternBlock : pattern.patterns.get(direction)) {
            for (Block b : patternBlock.blocks) {
                if (b != block) continue;
                blocks.add(patternBlock);
                continue block0;
            }
        }
    }

    public static int getWidth() {
        return width;
    }

    public static int getHeight() {
        return height;
    }

    public static int getDepth() {
        return depth;
    }

    public static AABB getSearchAABB(BlockPos pos) {
        return new AABB((double)(pos.m_123341_() - Patterns.getWidth()), (double)(pos.m_123342_() - Patterns.getHeight()), (double)(pos.m_123343_() - Patterns.getDepth()), (double)(pos.m_123341_() + Patterns.getWidth()), (double)(pos.m_123342_() + Patterns.getHeight()), (double)(pos.m_123343_() + Patterns.getDepth()));
    }

    private static int generateLength(Function<BlockPos, Integer> function) {
        int tier1 = Patterns.generateLengthForTier(TIER_1, function);
        int tier2 = Patterns.generateLengthForTier(TIER_2, function);
        int tier3 = Patterns.generateLengthForTier(TIER_3, function);
        int tier4 = Patterns.generateLengthForTier(TIER_4, function);
        int tier5 = Patterns.generateLengthForTier(TIER_5, function);
        return Math.max(tier1, Math.max(tier2, Math.max(tier3, Math.max(tier4, tier5))));
    }

    private static int generateLengthForTier(Pattern tier, Function<BlockPos, Integer> function) {
        List<Pattern.PatternBlock> pattern = tier.patterns.get(Direction.NORTH);
        int minLength = 0;
        int maxLength = 0;
        for (Pattern.PatternBlock block : pattern) {
            if (function.apply(block.pos) < minLength) {
                minLength = function.apply(block.pos);
            }
            if (function.apply(block.pos) <= maxLength) continue;
            maxLength = function.apply(block.pos);
        }
        return maxLength - minLength;
    }
}

