/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import wootrevived.woot.blocks.fake_spawner.FakeSpawnerBlockEntity;
import wootrevived.woot.util.common.RedstoneMode;

public record WootFakeSpawnerUpdate(BlockPos blockPos, RedstoneMode redstoneMode) {
    public static WootFakeSpawnerUpdate decode(FriendlyByteBuf buf) {
        return new WootFakeSpawnerUpdate(buf.m_130135_(), (RedstoneMode)buf.m_130066_(RedstoneMode.class));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
        buf.m_130068_((Enum)this.redstoneMode);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            FakeSpawnerBlockEntity fakeSpawnerBlockEntity;
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null || sender.m_9236_() == null) {
                return;
            }
            if (!sender.m_9236_().m_46749_(this.blockPos)) {
                return;
            }
            BlockEntity blockEntity = sender.m_9236_().m_7702_(this.blockPos);
            if (blockEntity instanceof FakeSpawnerBlockEntity && (fakeSpawnerBlockEntity = (FakeSpawnerBlockEntity)blockEntity).canPlayerAccess(sender)) {
                fakeSpawnerBlockEntity.handleNewState(this);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

