/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.network;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import wootrevived.woot.util.common.MachineSide;
import wootrevived.woot.util.common.MachineSideProperty;
import wootrevived.woot.util.common.RedstoneMode;
import wootrevived.woot.util.entity.WootMachineBlockEntity;

public record WootMachineUpdate(BlockPos blockPos, RedstoneMode redstoneMode, List<Map<MachineSide, MachineSideProperty>> listMachineProperties) {
    public static WootMachineUpdate decode(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        ArrayList<Map<MachineSide, MachineSideProperty>> listMachineProperties = new ArrayList<Map<MachineSide, MachineSideProperty>>(size);
        for (int i = 0; i < size; ++i) {
            EnumMap machineSideProperties = Maps.newEnumMap(MachineSide.class);
            for (int j = 0; j < MachineSide.values().length; ++j) {
                machineSideProperties.put((MachineSide)buf.m_130066_(MachineSide.class), (MachineSideProperty)buf.m_130066_(MachineSideProperty.class));
            }
            listMachineProperties.add(machineSideProperties);
        }
        return new WootMachineUpdate(buf.m_130135_(), (RedstoneMode)buf.m_130066_(RedstoneMode.class), listMachineProperties);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.listMachineProperties.size());
        for (Map<MachineSide, MachineSideProperty> machineProperties : this.listMachineProperties) {
            for (Map.Entry<MachineSide, MachineSideProperty> entry : machineProperties.entrySet()) {
                buf.m_130068_((Enum)entry.getKey());
                buf.m_130068_((Enum)entry.getValue());
            }
        }
        buf.m_130064_(this.blockPos);
        buf.m_130068_((Enum)this.redstoneMode);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            WootMachineBlockEntity wootMachineBlockEntity;
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null || sender.m_9236_() == null) {
                return;
            }
            if (!sender.m_9236_().m_46749_(this.blockPos)) {
                return;
            }
            BlockEntity blockEntity = sender.m_9236_().m_7702_(this.blockPos);
            if (blockEntity instanceof WootMachineBlockEntity && (wootMachineBlockEntity = (WootMachineBlockEntity)blockEntity).canPlayerAccess(sender)) {
                wootMachineBlockEntity.handleNewState(this);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

