/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.dye_liquifier;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.config.DyeLiquifierConfig;
import wootrevived.woot.registries.RecipesRegistry;
import wootrevived.woot.util.recipes.WootContainer;

public class DyeLiquifierRecipe
implements Recipe<WootContainer> {
    private final ResourceLocation recipeId;
    private final Ingredient ingredient;
    private final int energy;
    private final float red;
    private final float yellow;
    private final float blue;
    private final float white;
    public static float maxMultiplier = 0.0f;

    public DyeLiquifierRecipe(ResourceLocation recipeId, int energy, float red, float yellow, float blue, float white, @NotNull Ingredient ingredient) {
        this.recipeId = recipeId;
        this.ingredient = ingredient;
        this.energy = energy;
        this.red = red;
        this.yellow = yellow;
        this.blue = blue;
        this.white = white;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipesRegistry.DYE_LIQUIFIER_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipesRegistry.DYE_LIQUIFIER_RECIPE_TYPE.get();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getRed() {
        return Math.round(this.red * (float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue());
    }

    public int getYellow() {
        return Math.round(this.yellow * (float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue());
    }

    public int getBlue() {
        return Math.round(this.blue * (float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue());
    }

    public int getWhite() {
        return Math.round(this.white * (float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue());
    }

    public float getInternalRed() {
        return this.red;
    }

    public float getInternalYellow() {
        return this.yellow;
    }

    public float getInternalBlue() {
        return this.blue;
    }

    public float getInternalWhite() {
        return this.white;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int ingredientCount(Item item) {
        for (ItemStack stack : this.ingredient.m_43908_()) {
            if (!stack.m_150930_(item)) continue;
            return stack.m_41613_();
        }
        return 0;
    }

    public boolean matches(WootContainer container, Level level) {
        return this.ingredient.test(container.m_8020_(0));
    }

    public static void loadRecipes(@NotNull RecipeManager manager) {
        Validator.clear();
        maxMultiplier = 0.0f;
        for (Recipe recipe : manager.m_44051_()) {
            if (!(recipe instanceof DyeLiquifierRecipe)) continue;
            DyeLiquifierRecipe dyeLiquifierRecipe = (DyeLiquifierRecipe)recipe;
            Validator.add(dyeLiquifierRecipe.getIngredient(), dyeLiquifierRecipe);
            if (maxMultiplier < dyeLiquifierRecipe.getInternalRed()) {
                maxMultiplier = dyeLiquifierRecipe.getInternalRed();
            }
            if (maxMultiplier < dyeLiquifierRecipe.getInternalYellow()) {
                maxMultiplier = dyeLiquifierRecipe.getInternalYellow();
            }
            if (maxMultiplier < dyeLiquifierRecipe.getInternalBlue()) {
                maxMultiplier = dyeLiquifierRecipe.getInternalBlue();
            }
            if (!(maxMultiplier < dyeLiquifierRecipe.getInternalWhite())) continue;
            maxMultiplier = dyeLiquifierRecipe.getInternalWhite();
        }
    }

    @NotNull
    public ItemStack assemble(@NotNull WootContainer container, @NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_5598_() {
        return true;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public static class Validator {
        private static final List<Pair<Ingredient, DyeLiquifierRecipe>> validIngredients = new ArrayList<Pair<Ingredient, DyeLiquifierRecipe>>();

        public static boolean isIngredientValid(ItemStack item, Colors colors) {
            for (Pair<Ingredient, DyeLiquifierRecipe> ingredient : validIngredients) {
                if (!((Ingredient)ingredient.getFirst()).test(item)) continue;
                if (colors == Colors.ANY) {
                    return true;
                }
                DyeLiquifierRecipe recipe = (DyeLiquifierRecipe)ingredient.getSecond();
                return colors == Colors.RED && recipe.getInternalRed() > 0.0f || colors == Colors.YELLOW && recipe.getInternalYellow() > 0.0f || colors == Colors.BLUE && recipe.getInternalBlue() > 0.0f || colors == Colors.WHITE && recipe.getInternalWhite() > 0.0f;
            }
            return false;
        }

        protected static void add(Ingredient ingredient, DyeLiquifierRecipe recipe) {
            validIngredients.add((Pair<Ingredient, DyeLiquifierRecipe>)Pair.of((Object)ingredient, (Object)recipe));
        }

        protected static void clear() {
            validIngredients.clear();
        }
    }

    public static enum Colors {
        RED,
        YELLOW,
        BLUE,
        WHITE,
        ANY;

    }
}

