/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.dye_liquifier;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.Woot;
import wootrevived.woot.registries.RecipesRegistry;
import wootrevived.woot.util.helper.RecipeHelper;

public class DyeLiquifierRecipeBuilder {
    private int energy;
    private float red;
    private float yellow;
    private float blue;
    private float white;
    private float multiply = 1.0f;
    private Ingredient ingredient;

    protected DyeLiquifierRecipeBuilder() {
    }

    public static DyeLiquifierRecipeBuilder dyeLiquifierRecipe() {
        return new DyeLiquifierRecipeBuilder();
    }

    public DyeLiquifierRecipeBuilder energy(int energy) {
        this.energy = energy;
        return this;
    }

    public DyeLiquifierRecipeBuilder red(float red) {
        this.red = red;
        return this;
    }

    public DyeLiquifierRecipeBuilder yellow(float yellow) {
        this.yellow = yellow;
        return this;
    }

    public DyeLiquifierRecipeBuilder blue(float blue) {
        this.blue = blue;
        return this;
    }

    public DyeLiquifierRecipeBuilder white(float white) {
        this.white = white;
        return this;
    }

    public DyeLiquifierRecipeBuilder multiply(float multiply) {
        this.multiply = multiply;
        return this;
    }

    public DyeLiquifierRecipeBuilder ingredient(Ingredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer, String path) {
        consumer.accept(new Result(Woot.location("dye_liquifier/" + path), this.energy, this.red * this.multiply, this.yellow * this.multiply, this.blue * this.multiply, this.white * this.multiply, this.ingredient));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation recipeId;
        private final int energy;
        private final Ingredient ingredient;
        private final float red;
        private final float yellow;
        private final float blue;
        private final float white;

        protected Result(ResourceLocation recipeId, int energy, float red, float yellow, float blue, float white, Ingredient ingredient) {
            this.recipeId = recipeId;
            this.energy = energy;
            this.ingredient = ingredient;
            this.red = red;
            this.yellow = yellow;
            this.blue = blue;
            this.white = white;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("energy", (Number)this.energy);
            json.add("ingredient", RecipeHelper.IngredientInput.toJson(this.ingredient));
            json.addProperty("red_multiplier", (Number)Float.valueOf(this.red));
            json.addProperty("yellow_multiplier", (Number)Float.valueOf(this.yellow));
            json.addProperty("blue_multiplier", (Number)Float.valueOf(this.blue));
            json.addProperty("white_multiplier", (Number)Float.valueOf(this.white));
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RecipesRegistry.DYE_LIQUIFIER_RECIPE_SERIALIZER.get();
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.recipeId;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

