/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.dye_liquifier;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.recipes.dye_liquifier.DyeLiquifierRecipe;
import wootrevived.woot.util.helper.RecipeHelper;

public class DyeLiquifierRecipeSerializer<T extends DyeLiquifierRecipe>
implements RecipeSerializer<T> {
    protected final IFactory<T> factory;

    public DyeLiquifierRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    @NotNull
    public T fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        int energy = GsonHelper.m_13824_((JsonObject)json, (String)"energy", (int)0);
        float red = GsonHelper.m_13820_((JsonObject)json, (String)"red_multiplier", (float)0.0f);
        float yellow = GsonHelper.m_13820_((JsonObject)json, (String)"yellow_multiplier", (float)0.0f);
        float blue = GsonHelper.m_13820_((JsonObject)json, (String)"blue_multiplier", (float)0.0f);
        float white = GsonHelper.m_13820_((JsonObject)json, (String)"white_multiplier", (float)0.0f);
        Ingredient ingredient = RecipeHelper.IngredientInput.fromJson(json, "ingredient");
        return (T)((DyeLiquifierRecipe)this.factory.create(recipeId, energy, red, yellow, blue, white, ingredient));
    }

    @Nullable
    public T fromNetwork(@NotNull ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int energy = buffer.m_130242_();
        float red = buffer.readFloat();
        float yellow = buffer.readFloat();
        float blue = buffer.readFloat();
        float white = buffer.readFloat();
        Ingredient ingredient = RecipeHelper.IngredientInput.fromNetwork(buffer);
        return (T)((DyeLiquifierRecipe)this.factory.create(recipeId, energy, red, yellow, blue, white, ingredient));
    }

    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        buffer.m_130130_(((DyeLiquifierRecipe)recipe).getEnergy());
        buffer.writeFloat((float)((DyeLiquifierRecipe)recipe).getRed());
        buffer.writeFloat((float)((DyeLiquifierRecipe)recipe).getYellow());
        buffer.writeFloat((float)((DyeLiquifierRecipe)recipe).getBlue());
        buffer.writeFloat((float)((DyeLiquifierRecipe)recipe).getWhite());
        RecipeHelper.IngredientInput.toNetwork(buffer, ((DyeLiquifierRecipe)recipe).getIngredient());
    }

    public static interface IFactory<T> {
        public T create(ResourceLocation var1, int var2, float var3, float var4, float var5, float var6, @NotNull Ingredient var7);
    }
}

