/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.fluid_infuser;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.registries.RecipesRegistry;
import wootrevived.woot.util.recipes.WootContainer;

public class FluidInfuserRecipe
implements Recipe<WootContainer> {
    private final ResourceLocation recipeId;
    private final int energy;
    private final FluidStack inputFluid;
    private final Ingredient ingredient;
    private final FluidStack outputFluid;

    public FluidInfuserRecipe(ResourceLocation recipeId, int energy, @NotNull FluidStack inputFluid, @NotNull Ingredient ingredient, @NotNull FluidStack outputFluid) {
        this.recipeId = recipeId;
        this.energy = energy;
        this.inputFluid = inputFluid;
        this.ingredient = ingredient;
        this.outputFluid = outputFluid;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipesRegistry.FLUID_INFUSER_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipesRegistry.FLUID_INFUSER_RECIPE_TYPE.get();
    }

    public FluidStack getInputFluid() {
        return this.inputFluid.copy();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid.copy();
    }

    public int getEnergy() {
        return this.energy;
    }

    public int ingredientCount(Item item) {
        for (ItemStack stack : this.ingredient.m_43908_()) {
            if (!stack.m_150930_(item)) continue;
            return stack.m_41613_();
        }
        return 0;
    }

    public boolean matches(@NotNull WootContainer container, @NotNull Level level) {
        if (!this.getInputFluid().isFluidEqual(container.getFluid(0))) {
            return false;
        }
        return this.getIngredient().test(container.m_8020_(1));
    }

    public static void loadRecipes(@NotNull RecipeManager manager) {
        Validator.clear();
        for (Recipe recipe : manager.m_44051_()) {
            if (!(recipe instanceof FluidInfuserRecipe)) continue;
            FluidInfuserRecipe fluidInfuserRecipe = (FluidInfuserRecipe)recipe;
            Validator.add(fluidInfuserRecipe.ingredient, fluidInfuserRecipe.inputFluid);
        }
    }

    @NotNull
    public ItemStack assemble(@NotNull WootContainer container, @NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_5598_() {
        return true;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public static class Validator {
        private static final List<Ingredient> validIngredients = new ArrayList<Ingredient>();
        private static final List<FluidStack> validFluids = new ArrayList<FluidStack>();

        public static boolean isCatalystValid(ItemStack item) {
            for (Ingredient ingredient : validIngredients) {
                if (!ingredient.test(item)) continue;
                return true;
            }
            return false;
        }

        public static boolean isFluidValid(FluidStack fluid) {
            for (FluidStack fluidStack : validFluids) {
                if (!fluidStack.isFluidEqual(fluid)) continue;
                return true;
            }
            return false;
        }

        protected static void add(Ingredient ingredient, FluidStack fluid) {
            validIngredients.add(ingredient);
            validFluids.add(fluid);
        }

        protected static void clear() {
            validIngredients.clear();
            validFluids.clear();
        }
    }
}

