/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.fluid_infuser;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.Woot;
import wootrevived.woot.registries.RecipesRegistry;
import wootrevived.woot.util.helper.RecipeHelper;

public class FluidInfuserRecipeBuilder {
    private FluidStack inputFluid;
    private Ingredient ingredient;
    private final FluidStack outputFluid;
    private int energy;

    protected FluidInfuserRecipeBuilder(FluidStack outputFluid) {
        this.outputFluid = outputFluid;
    }

    public static FluidInfuserRecipeBuilder fluidInfuserRecipe(Fluid outputFluid, int amount) {
        return new FluidInfuserRecipeBuilder(new FluidStack(outputFluid, amount));
    }

    public static FluidInfuserRecipeBuilder fluidInfuserRecipe(Fluid outputFluid) {
        return new FluidInfuserRecipeBuilder(new FluidStack(outputFluid, 1000));
    }

    public static FluidInfuserRecipeBuilder fluidInfuserRecipe(FluidStack outputFluid) {
        return new FluidInfuserRecipeBuilder(outputFluid);
    }

    public FluidInfuserRecipeBuilder fluid(Fluid fluid, int amount) {
        this.inputFluid = new FluidStack(fluid, amount);
        return this;
    }

    public FluidInfuserRecipeBuilder fluid(Fluid fluid) {
        this.inputFluid = new FluidStack(fluid, 1000);
        return this;
    }

    public FluidInfuserRecipeBuilder fluid(FluidStack fluidStack) {
        this.inputFluid = fluidStack;
        return this;
    }

    public FluidInfuserRecipeBuilder ingredient(Ingredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public FluidInfuserRecipeBuilder energy(int energy) {
        this.energy = energy;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer, String path) {
        consumer.accept(new Result(Woot.location("fluid_infuser/" + path), this.energy, this.inputFluid, this.ingredient, this.outputFluid));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation recipeId;
        private final int energy;
        private final FluidStack inputFluid;
        private final Ingredient ingredient;
        private final FluidStack outputFluid;

        protected Result(ResourceLocation recipeId, int energy, FluidStack inputFluid, Ingredient ingredient, FluidStack outputFluid) {
            this.recipeId = recipeId;
            this.energy = energy;
            this.inputFluid = inputFluid;
            this.ingredient = ingredient;
            this.outputFluid = outputFluid;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("energy", (Number)this.energy);
            json.add("input_fluid", RecipeHelper.FluidInput.toJson(this.inputFluid));
            json.add("ingredient", RecipeHelper.IngredientInput.toJson(this.ingredient));
            json.add("output_fluid", RecipeHelper.FluidOutput.toJson(this.outputFluid));
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RecipesRegistry.FLUID_INFUSER_RECIPE_SERIALIZER.get();
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.recipeId;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

