/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.fluid_infuser;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.recipes.fluid_infuser.FluidInfuserRecipe;
import wootrevived.woot.util.helper.RecipeHelper;

public class FluidInfuserRecipeSerializer<T extends FluidInfuserRecipe>
implements RecipeSerializer<T> {
    protected final IFactory<T> factory;

    public FluidInfuserRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    @NotNull
    public T fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        int energy = GsonHelper.m_13824_((JsonObject)json, (String)"energy", (int)0);
        FluidStack inputFluid = RecipeHelper.FluidInput.fromJson(json, "input_fluid");
        Ingredient ingredient = RecipeHelper.IngredientInput.fromJson(json, "ingredient");
        FluidStack outputFluid = RecipeHelper.FluidOutput.fromJson(json, "output_fluid");
        return (T)((FluidInfuserRecipe)this.factory.create(recipeId, energy, inputFluid, ingredient, outputFluid));
    }

    @Nullable
    public T fromNetwork(@NotNull ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int energy = buffer.m_130242_();
        FluidStack inputFluid = RecipeHelper.FluidInput.fromNetwork(buffer);
        Ingredient ingredient = RecipeHelper.IngredientInput.fromNetwork(buffer);
        FluidStack outputFluid = RecipeHelper.FluidOutput.fromNetwork(buffer);
        return (T)((FluidInfuserRecipe)this.factory.create(recipeId, energy, inputFluid, ingredient, outputFluid));
    }

    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        buffer.m_130130_(((FluidInfuserRecipe)recipe).getEnergy());
        RecipeHelper.FluidInput.toNetwork(buffer, ((FluidInfuserRecipe)recipe).getInputFluid());
        RecipeHelper.IngredientInput.toNetwork(buffer, ((FluidInfuserRecipe)recipe).getIngredient());
        RecipeHelper.FluidOutput.toNetwork(buffer, ((FluidInfuserRecipe)recipe).getOutputFluid());
    }

    public static interface IFactory<T> {
        public T create(ResourceLocation var1, int var2, FluidStack var3, Ingredient var4, FluidStack var5);
    }
}

