/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.item_infuser;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.registries.RecipesRegistry;
import wootrevived.woot.util.recipes.WootContainer;

public class ItemInfuserRecipe
implements Recipe<WootContainer> {
    private final ResourceLocation recipeId;
    private final int energy;
    private final FluidStack fluid;
    private final Ingredient ingredient;
    private final Optional<Ingredient> augment;
    private final ItemStack output;

    public ItemInfuserRecipe(ResourceLocation recipeId, int energy, @NotNull FluidStack fluid, @NotNull Ingredient ingredient, @NotNull Optional<Ingredient> augment, @NotNull ItemStack output) {
        this.recipeId = recipeId;
        this.energy = energy;
        this.fluid = fluid;
        this.ingredient = ingredient;
        this.augment = augment;
        this.output = output;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipesRegistry.ITEM_INFUSER_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipesRegistry.ITEM_INFUSER_RECIPE_TYPE.get();
    }

    @NotNull
    public FluidStack getFluid() {
        return this.fluid.copy();
    }

    @NotNull
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @NotNull
    public Optional<Ingredient> getAugment() {
        return this.augment;
    }

    @NotNull
    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public int getEnergy() {
        return this.energy;
    }

    public int ingredientCount(Item item) {
        for (ItemStack stack : this.ingredient.m_43908_()) {
            if (!stack.m_150930_(item)) continue;
            return stack.m_41613_();
        }
        return 0;
    }

    public int augmentCount(Item item) {
        if (this.augment.isEmpty()) {
            return 0;
        }
        for (ItemStack stack : this.augment.get().m_43908_()) {
            if (!stack.m_150930_(item)) continue;
            return stack.m_41613_();
        }
        return 0;
    }

    public boolean matches(@NotNull WootContainer container, @NotNull Level level) {
        if (!this.getFluid().isFluidEqual(container.getFluid(0))) {
            return false;
        }
        if (!this.getIngredient().test(container.m_8020_(1))) {
            return false;
        }
        return this.getAugment().isEmpty() || this.getAugment().get().test(container.m_8020_(2));
    }

    public static void loadRecipes(@NotNull RecipeManager manager) {
        Validator.clear();
        for (Recipe recipe : manager.m_44051_()) {
            if (!(recipe instanceof ItemInfuserRecipe)) continue;
            ItemInfuserRecipe fluidInfuserRecipe = (ItemInfuserRecipe)recipe;
            Validator.add(fluidInfuserRecipe.ingredient, fluidInfuserRecipe.augment, fluidInfuserRecipe.fluid);
        }
    }

    @NotNull
    public ItemStack assemble(@NotNull WootContainer container, @NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_5598_() {
        return true;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public static class Validator {
        private static final List<Ingredient> validIngredients = new ArrayList<Ingredient>();
        private static final List<Ingredient> validAugments = new ArrayList<Ingredient>();
        private static final List<FluidStack> validFluids = new ArrayList<FluidStack>();

        public static boolean isIngredientValid(ItemStack item) {
            for (Ingredient ingredient : validIngredients) {
                if (!ingredient.test(item)) continue;
                return true;
            }
            return false;
        }

        public static boolean isAugmentValid(ItemStack item) {
            for (Ingredient ingredient : validAugments) {
                if (!ingredient.test(item)) continue;
                return true;
            }
            return false;
        }

        public static boolean isFluidValid(FluidStack fluid) {
            for (FluidStack fluidStack : validFluids) {
                if (!fluidStack.isFluidEqual(fluid)) continue;
                return true;
            }
            return false;
        }

        protected static void add(Ingredient ingredient, Optional<Ingredient> augment, FluidStack fluid) {
            validIngredients.add(ingredient);
            augment.ifPresent(validAugments::add);
            validFluids.add(fluid);
        }

        protected static void clear() {
            validIngredients.clear();
            validAugments.clear();
            validFluids.clear();
        }
    }
}

