/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.item_infuser;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.Woot;
import wootrevived.woot.registries.RecipesRegistry;
import wootrevived.woot.util.helper.RecipeHelper;

public class ItemInfuserRecipeBuilder {
    private FluidStack fluid;
    private Ingredient ingredient;
    private Ingredient augment;
    private final ItemStack output;
    private int energy;

    protected ItemInfuserRecipeBuilder(ItemLike output, int count) {
        this.output = output.m_5456_().m_7968_();
        this.output.m_41764_(count);
        this.augment = Ingredient.f_43901_;
    }

    public static ItemInfuserRecipeBuilder itemInfuserRecipe(ItemLike output, int count) {
        return new ItemInfuserRecipeBuilder(output, count);
    }

    public static ItemInfuserRecipeBuilder itemInfuserRecipe(ItemLike output) {
        return new ItemInfuserRecipeBuilder(output, 1);
    }

    public ItemInfuserRecipeBuilder fluid(Fluid fluid, int amount) {
        this.fluid = new FluidStack(fluid, amount);
        return this;
    }

    public ItemInfuserRecipeBuilder fluid(Fluid fluid) {
        this.fluid = new FluidStack(fluid, 1000);
        return this;
    }

    public ItemInfuserRecipeBuilder fluid(FluidStack fluidStack) {
        this.fluid = fluidStack;
        return this;
    }

    public ItemInfuserRecipeBuilder ingredient(Ingredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public ItemInfuserRecipeBuilder augment(Ingredient augment) {
        this.augment = augment;
        return this;
    }

    public ItemInfuserRecipeBuilder energy(int energy) {
        this.energy = energy;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_()).m_135815_());
    }

    public void save(Consumer<FinishedRecipe> consumer, String path) {
        consumer.accept(new Result(Woot.location("item_infuser/" + path), this.energy, this.fluid, this.ingredient, this.augment, this.output));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation recipeId;
        private final int energy;
        private final FluidStack fluid;
        private final Ingredient ingredient;
        private final Ingredient augment;
        private final ItemStack output;

        protected Result(ResourceLocation recipeId, int energy, FluidStack fluid, Ingredient ingredient, Ingredient augment, ItemStack output) {
            this.recipeId = recipeId;
            this.energy = energy;
            this.fluid = fluid;
            this.ingredient = ingredient;
            this.augment = augment;
            this.output = output;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("energy", (Number)this.energy);
            json.add("fluid", RecipeHelper.FluidInput.toJson(this.fluid));
            json.add("ingredient", RecipeHelper.IngredientInput.toJson(this.ingredient));
            if (this.augment != null) {
                json.add("augment", RecipeHelper.IngredientInput.toJson(this.augment));
            }
            json.add("output", RecipeHelper.ItemOutput.toJson(this.output));
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RecipesRegistry.ITEM_INFUSER_RECIPE_SERIALIZER.get();
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.recipeId;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

