/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.item_infuser;

import com.google.gson.JsonObject;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.recipes.item_infuser.ItemInfuserRecipe;
import wootrevived.woot.util.helper.RecipeHelper;

public class ItemInfuserRecipeSerializer<T extends ItemInfuserRecipe>
implements RecipeSerializer<T> {
    protected final IFactory<T> factory;

    public ItemInfuserRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    @NotNull
    public T fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        int energy = GsonHelper.m_13824_((JsonObject)json, (String)"energy", (int)0);
        FluidStack fluid = RecipeHelper.FluidInput.fromJson(json, "fluid");
        Ingredient ingredient = RecipeHelper.IngredientInput.fromJson(json, "ingredient");
        Ingredient augment = null;
        if (json.has("augment")) {
            augment = RecipeHelper.IngredientInput.fromJson(json, "augment");
        }
        ItemStack output = RecipeHelper.ItemOutput.fromJson(json, "output");
        return (T)((ItemInfuserRecipe)this.factory.create(recipeId, energy, fluid, ingredient, Optional.ofNullable(augment), output));
    }

    @Nullable
    public T fromNetwork(@NotNull ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int energy = buffer.m_130242_();
        FluidStack fluid = RecipeHelper.FluidInput.fromNetwork(buffer);
        Ingredient ingredient = RecipeHelper.IngredientInput.fromNetwork(buffer);
        Ingredient augment = null;
        if (buffer.readBoolean()) {
            augment = RecipeHelper.IngredientInput.fromNetwork(buffer);
        }
        ItemStack output = RecipeHelper.ItemOutput.fromNetwork(buffer);
        return (T)((ItemInfuserRecipe)this.factory.create(recipeId, energy, fluid, ingredient, Optional.ofNullable(augment), output));
    }

    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        buffer.m_130130_(((ItemInfuserRecipe)recipe).getEnergy());
        RecipeHelper.FluidInput.toNetwork(buffer, ((ItemInfuserRecipe)recipe).getFluid());
        RecipeHelper.IngredientInput.toNetwork(buffer, ((ItemInfuserRecipe)recipe).getIngredient());
        buffer.writeBoolean(((ItemInfuserRecipe)recipe).getAugment().isPresent());
        if (((ItemInfuserRecipe)recipe).getAugment().isPresent()) {
            RecipeHelper.IngredientInput.toNetwork(buffer, ((ItemInfuserRecipe)recipe).getAugment().get());
        }
        RecipeHelper.ItemOutput.toNetwork(buffer, ((ItemInfuserRecipe)recipe).getOutput());
    }

    public static interface IFactory<T> {
        public T create(ResourceLocation var1, int var2, FluidStack var3, Ingredient var4, Optional<Ingredient> var5, ItemStack var6);
    }
}

