/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.stygian_anvil;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.Woot;
import wootrevived.woot.registries.RecipesRegistry;
import wootrevived.woot.util.helper.RecipeHelper;

public class StygianAnvilRecipeBuilder {
    private Ingredient base;
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private final ItemStack output;

    protected StygianAnvilRecipeBuilder(ItemLike output, int count) {
        this.output = output.m_5456_().m_7968_();
        this.output.m_41764_(count);
    }

    public static StygianAnvilRecipeBuilder anvilRecipe(ItemLike output, int count) {
        return new StygianAnvilRecipeBuilder(output, count);
    }

    public static StygianAnvilRecipeBuilder anvilRecipe(ItemLike output) {
        return new StygianAnvilRecipeBuilder(output, 1);
    }

    public StygianAnvilRecipeBuilder base(Ingredient base) {
        this.base = base;
        return this;
    }

    public StygianAnvilRecipeBuilder ingredient(Ingredient ingredient) {
        this.ingredients.add(ingredient);
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_()).m_135815_());
    }

    public void save(Consumer<FinishedRecipe> consumer, String path) {
        consumer.accept(new Result(Woot.location("stygian_anvil/" + path), this.base, this.ingredients, this.output));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation recipeId;
        private final Ingredient base;
        private final List<Ingredient> complementaries;
        private final ItemStack outputItem;

        protected Result(ResourceLocation recipeId, @NotNull Ingredient base, @NotNull List<Ingredient> complementaries, @NotNull ItemStack outputItem) {
            this.recipeId = recipeId;
            this.base = base;
            this.complementaries = complementaries;
            this.outputItem = outputItem;
        }

        public void m_7917_(JsonObject json) {
            json.add("base", RecipeHelper.IngredientInput.toJson(this.base));
            if (!this.complementaries.isEmpty()) {
                json.add("first_complementary", RecipeHelper.IngredientInput.toJson(this.complementaries.get(0)));
            }
            if (this.complementaries.size() > 1) {
                json.add("second_complementary", RecipeHelper.IngredientInput.toJson(this.complementaries.get(1)));
            }
            if (this.complementaries.size() > 2) {
                json.add("third_complementary", RecipeHelper.IngredientInput.toJson(this.complementaries.get(2)));
            }
            if (this.complementaries.size() > 3) {
                json.add("fourth_complementary", RecipeHelper.IngredientInput.toJson(this.complementaries.get(3)));
            }
            json.add("output", RecipeHelper.ItemOutput.toJson(this.outputItem));
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RecipesRegistry.ANVIL_RECIPE_SERIALIZER.get();
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.recipeId;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

