/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.stygian_anvil;

import com.google.gson.JsonObject;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.recipes.stygian_anvil.StygianAnvilRecipe;
import wootrevived.woot.util.helper.RecipeHelper;

public class StygianAnvilRecipeSerializer<T extends StygianAnvilRecipe>
implements RecipeSerializer<T> {
    protected final IFactory<T> factory;

    public StygianAnvilRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    @NotNull
    public T fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        Ingredient base = RecipeHelper.IngredientInput.fromJson(json, "base");
        Ingredient firstComplementary = null;
        if (json.has("first_complementary")) {
            firstComplementary = RecipeHelper.IngredientInput.fromJson(json, "first_complementary");
        }
        Ingredient secondComplementary = null;
        if (json.has("second_complementary")) {
            secondComplementary = RecipeHelper.IngredientInput.fromJson(json, "second_complementary");
        }
        Ingredient thirdComplementary = null;
        if (json.has("third_complementary")) {
            thirdComplementary = RecipeHelper.IngredientInput.fromJson(json, "third_complementary");
        }
        Ingredient fourthComplementary = null;
        if (json.has("fourth_complementary")) {
            fourthComplementary = RecipeHelper.IngredientInput.fromJson(json, "fourth_complementary");
        }
        ItemStack outputItem = RecipeHelper.ItemOutput.fromJson(json, "output");
        return (T)((StygianAnvilRecipe)this.factory.create(recipeId, base, Optional.ofNullable(firstComplementary), Optional.ofNullable(secondComplementary), Optional.ofNullable(thirdComplementary), Optional.ofNullable(fourthComplementary), outputItem));
    }

    @Nullable
    public T fromNetwork(@NotNull ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Ingredient base = RecipeHelper.IngredientInput.fromNetwork(buffer);
        Ingredient firstComplementary = null;
        if (buffer.readBoolean()) {
            firstComplementary = RecipeHelper.IngredientInput.fromNetwork(buffer);
        }
        Ingredient secondComplementary = null;
        if (buffer.readBoolean()) {
            secondComplementary = RecipeHelper.IngredientInput.fromNetwork(buffer);
        }
        Ingredient thirdComplementary = null;
        if (buffer.readBoolean()) {
            thirdComplementary = RecipeHelper.IngredientInput.fromNetwork(buffer);
        }
        Ingredient fourthComplementary = null;
        if (buffer.readBoolean()) {
            fourthComplementary = RecipeHelper.IngredientInput.fromNetwork(buffer);
        }
        ItemStack output = RecipeHelper.ItemOutput.fromNetwork(buffer);
        return (T)((StygianAnvilRecipe)this.factory.create(recipeId, base, Optional.ofNullable(firstComplementary), Optional.ofNullable(secondComplementary), Optional.ofNullable(thirdComplementary), Optional.ofNullable(fourthComplementary), output));
    }

    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        RecipeHelper.IngredientInput.toNetwork(buffer, ((StygianAnvilRecipe)recipe).getBase());
        buffer.writeBoolean(((StygianAnvilRecipe)recipe).getFirstComplementary().isPresent());
        if (((StygianAnvilRecipe)recipe).getFirstComplementary().isPresent()) {
            RecipeHelper.IngredientInput.toNetwork(buffer, ((StygianAnvilRecipe)recipe).getFirstComplementary().get());
        }
        buffer.writeBoolean(((StygianAnvilRecipe)recipe).getSecondComplementary().isPresent());
        if (((StygianAnvilRecipe)recipe).getSecondComplementary().isPresent()) {
            RecipeHelper.IngredientInput.toNetwork(buffer, ((StygianAnvilRecipe)recipe).getSecondComplementary().get());
        }
        buffer.writeBoolean(((StygianAnvilRecipe)recipe).getThirdComplementary().isPresent());
        if (((StygianAnvilRecipe)recipe).getThirdComplementary().isPresent()) {
            RecipeHelper.IngredientInput.toNetwork(buffer, ((StygianAnvilRecipe)recipe).getThirdComplementary().get());
        }
        buffer.writeBoolean(((StygianAnvilRecipe)recipe).getFourthComplementary().isPresent());
        if (((StygianAnvilRecipe)recipe).getFourthComplementary().isPresent()) {
            RecipeHelper.IngredientInput.toNetwork(buffer, ((StygianAnvilRecipe)recipe).getFourthComplementary().get());
        }
        RecipeHelper.ItemOutput.toNetwork(buffer, ((StygianAnvilRecipe)recipe).getOutput());
    }

    public static interface IFactory<T> {
        public T create(ResourceLocation var1, Ingredient var2, Optional<Ingredient> var3, Optional<Ingredient> var4, Optional<Ingredient> var5, Optional<Ingredient> var6, ItemStack var7);
    }
}

