/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.registries;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import wootrevived.woot.Woot;
import wootrevived.woot.init.Registry;
import wootrevived.woot.util.fluid.WootBucketItem;
import wootrevived.woot.util.fluid.WootFluidType;

public class FluidsRegistry {
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"woot_revived");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUIDS, (String)"woot_revived");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BLOCKS, (String)"woot_revived");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ITEMS, (String)"woot_revived");
    public static final ResourceLocation UNDERWATER_OVERLAY_RL = ResourceLocation.m_135820_((String)"misc/underwater");
    public static final FluidType.Properties defaultProperties = FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).canSwim(true).canDrown(true).canPushEntity(true).supportsBoating(true);
    public static String VITALITY_FUEL_FLUID_TAG = "vitality_fuel_fluid";
    public static final ResourceLocation VITALITY_FUEL_STILL_TEX = Woot.location("block/vitality_fuel_still");
    public static final ResourceLocation VITALITY_FUEL_FLOW_TEX = Woot.location("block/vitality_fuel_flow");
    public static RegistryObject<FluidType> VITALITY_FUEL_FLUID_TYPE = FLUID_TYPES.register(VITALITY_FUEL_FLUID_TAG, () -> new WootFluidType(VITALITY_FUEL_STILL_TEX, VITALITY_FUEL_FLOW_TEX, UNDERWATER_OVERLAY_RL, 46, 184, 184, defaultProperties));
    public static final RegistryObject<FlowingFluid> SOURCE_VITALITY_FUEL_FLUID = FLUIDS.register(VITALITY_FUEL_FLUID_TAG, () -> new ForgeFlowingFluid.Source(VITALITY_FUEL_FLUID_PROPERTIES));
    public static final RegistryObject<FlowingFluid> FLOWING_VITALITY_FUEL_FLUID = FLUIDS.register(VITALITY_FUEL_FLUID_TAG + "_flowing", () -> new ForgeFlowingFluid.Flowing(VITALITY_FUEL_FLUID_PROPERTIES));
    public static final RegistryObject<LiquidBlock> VITALITY_FUEL_FLUID_BLOCK = BLOCKS.register(VITALITY_FUEL_FLUID_TAG + "_block", () -> new LiquidBlock(SOURCE_VITALITY_FUEL_FLUID, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_).m_222994_()));
    public static final RegistryObject<BucketItem> VITALITY_FUEL_FLUID_BUCKET = ITEMS.register(VITALITY_FUEL_FLUID_TAG + "_bucket", () -> new WootBucketItem((Supplier<? extends Fluid>)SOURCE_VITALITY_FUEL_FLUID));
    public static final ForgeFlowingFluid.Properties VITALITY_FUEL_FLUID_PROPERTIES = new ForgeFlowingFluid.Properties(VITALITY_FUEL_FLUID_TYPE, SOURCE_VITALITY_FUEL_FLUID, FLOWING_VITALITY_FUEL_FLUID).block(VITALITY_FUEL_FLUID_BLOCK).bucket(VITALITY_FUEL_FLUID_BUCKET);
    public static String PURE_DYE_FLUID_TAG = "pure_dye_fluid";
    public static final ResourceLocation PURE_DYE_STILL_TEX = Woot.location("block/pure_dye_still");
    public static final ResourceLocation PURE_DYE_FLOW_TEX = Woot.location("block/pure_dye_flow");
    public static RegistryObject<FluidType> PURE_DYE_FLUID_TYPE = FLUID_TYPES.register(PURE_DYE_FLUID_TAG, () -> new WootFluidType(PURE_DYE_STILL_TEX, PURE_DYE_FLOW_TEX, UNDERWATER_OVERLAY_RL, 233, 233, 233, defaultProperties));
    public static final RegistryObject<FlowingFluid> SOURCE_PURE_DYE_FLUID = FLUIDS.register(PURE_DYE_FLUID_TAG, () -> new ForgeFlowingFluid.Source(PURE_DYE_FLUID_PROPERTIES));
    public static final RegistryObject<FlowingFluid> FLOWING_PURE_DYE_FLUID = FLUIDS.register(PURE_DYE_FLUID_TAG + "_flowing", () -> new ForgeFlowingFluid.Flowing(PURE_DYE_FLUID_PROPERTIES));
    public static final RegistryObject<LiquidBlock> PURE_DYE_FLUID_BLOCK = BLOCKS.register(PURE_DYE_FLUID_TAG + "_block", () -> new LiquidBlock(SOURCE_PURE_DYE_FLUID, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_).m_222994_()));
    public static final RegistryObject<BucketItem> PURE_DYE_FLUID_BUCKET = ITEMS.register(PURE_DYE_FLUID_TAG + "_bucket", () -> new WootBucketItem((Supplier<? extends Fluid>)SOURCE_PURE_DYE_FLUID));
    public static final ForgeFlowingFluid.Properties PURE_DYE_FLUID_PROPERTIES = new ForgeFlowingFluid.Properties(PURE_DYE_FLUID_TYPE, SOURCE_PURE_DYE_FLUID, FLOWING_PURE_DYE_FLUID).block(PURE_DYE_FLUID_BLOCK).bucket(PURE_DYE_FLUID_BUCKET);
    public static String ENCHANTED_FLUID_TAG = "enchanted_fluid";
    public static final ResourceLocation ENCHANTED_STILL_TEX = Woot.location("block/enchanted_still");
    public static final ResourceLocation ENCHANTED_FLOW_TEX = Woot.location("block/enchanted_flow");
    public static RegistryObject<FluidType> ENCHANTED_FLUID_TYPE = FLUID_TYPES.register(ENCHANTED_FLUID_TAG, () -> new WootFluidType(ENCHANTED_STILL_TEX, ENCHANTED_FLOW_TEX, UNDERWATER_OVERLAY_RL, 53, 76, 213, defaultProperties));
    public static final RegistryObject<FlowingFluid> SOURCE_ENCHANTED_FLUID = FLUIDS.register(ENCHANTED_FLUID_TAG, () -> new ForgeFlowingFluid.Source(ENCHANTED_FLUID_PROPERTIES));
    public static final RegistryObject<FlowingFluid> FLOWING_ENCHANTED_FLUID = FLUIDS.register(ENCHANTED_FLUID_TAG + "_flowing", () -> new ForgeFlowingFluid.Flowing(ENCHANTED_FLUID_PROPERTIES));
    public static final RegistryObject<LiquidBlock> ENCHANTED_FLUID_BLOCK = BLOCKS.register(ENCHANTED_FLUID_TAG + "_block", () -> new LiquidBlock(SOURCE_ENCHANTED_FLUID, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_).m_222994_()));
    public static final RegistryObject<WootBucketItem> ENCHANTED_FLUID_BUCKET = ITEMS.register(ENCHANTED_FLUID_TAG + "_bucket", () -> new WootBucketItem((Supplier<? extends Fluid>)SOURCE_ENCHANTED_FLUID));
    public static final ForgeFlowingFluid.Properties ENCHANTED_FLUID_PROPERTIES = new ForgeFlowingFluid.Properties(ENCHANTED_FLUID_TYPE, SOURCE_ENCHANTED_FLUID, FLOWING_ENCHANTED_FLUID).block(ENCHANTED_FLUID_BLOCK).bucket(ENCHANTED_FLUID_BUCKET);
    public static String MOB_TEARS_FLUID_TAG = "mob_tears_fluid";
    public static final ResourceLocation MOB_TEARS_STILL_TEX = Woot.location("block/mob_tears_still");
    public static final ResourceLocation MOB_TEARS_FLOW_TEX = Woot.location("block/mob_tears_flow");
    public static RegistryObject<FluidType> MOB_TEARS_FLUID_TYPE = FLUID_TYPES.register(MOB_TEARS_FLUID_TAG, () -> new WootFluidType(MOB_TEARS_STILL_TEX, MOB_TEARS_FLOW_TEX, UNDERWATER_OVERLAY_RL, 94, 184, 33, defaultProperties));
    public static final RegistryObject<FlowingFluid> SOURCE_MOB_TEARS_FLUID = FLUIDS.register(MOB_TEARS_FLUID_TAG, () -> new ForgeFlowingFluid.Source(MOB_TEARS_FLUID_PROPERTIES));
    public static final RegistryObject<FlowingFluid> FLOWING_MOB_TEARS_FLUID = FLUIDS.register(MOB_TEARS_FLUID_TAG + "_flowing", () -> new ForgeFlowingFluid.Flowing(MOB_TEARS_FLUID_PROPERTIES));
    public static final RegistryObject<LiquidBlock> MOB_TEARS_FLUID_BLOCK = BLOCKS.register(MOB_TEARS_FLUID_TAG + "_block", () -> new LiquidBlock(SOURCE_MOB_TEARS_FLUID, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_).m_222994_()));
    public static final RegistryObject<BucketItem> MOB_TEARS_FLUID_BUCKET = ITEMS.register(MOB_TEARS_FLUID_TAG + "_bucket", () -> new WootBucketItem((Supplier<? extends Fluid>)SOURCE_MOB_TEARS_FLUID));
    public static final ForgeFlowingFluid.Properties MOB_TEARS_FLUID_PROPERTIES = new ForgeFlowingFluid.Properties(MOB_TEARS_FLUID_TYPE, SOURCE_MOB_TEARS_FLUID, FLOWING_MOB_TEARS_FLUID).block(MOB_TEARS_FLUID_BLOCK).bucket(MOB_TEARS_FLUID_BUCKET);

    public static void register(IEventBus bus) {
        FLUID_TYPES.register(bus);
        FLUIDS.register(bus);
        BLOCKS.register(bus);
        ITEMS.register(bus);
        for (RegistryObject item : ITEMS.getEntries()) {
            Registry.addToCreativeTab((RegistryObject<? extends ItemLike>)item);
        }
    }
}

