/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.registries;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import wootrevived.api.WootUpgradeItem;
import wootrevived.api.registrations.WootUpgradeItemRegistration;
import wootrevived.woot.init.Registry;
import wootrevived.woot.init.WootPlugins;
import wootrevived.woot.items.basic.BasicItem;

public class UpgradeItemsRegistry
extends WootUpgradeItemRegistration {
    private final IEventBus wootBus;
    private static final Map<String, RegistryObject<? extends WootUpgradeItem>> REGISTRY = new HashMap<String, RegistryObject<? extends WootUpgradeItem>>();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ITEMS, (String)"woot_revived");
    public static final String UPGRADE_BASE_TAG = "upgrade_base";
    public static final RegistryObject<BasicItem> UPGRADE_BASE_ITEM = ITEMS.register("upgrade_base", () -> new BasicItem(BasicItem.Type.UPGRADE_BASE));

    private UpgradeItemsRegistry(IEventBus wootBus) {
        this.wootBus = wootBus;
    }

    @Override
    public void register(RegistryObject<? extends WootUpgradeItem> item) {
        if (item.getId() == null) {
            return;
        }
        REGISTRY.put(UpgradeItemsRegistry.getNameFromItem(item), item);
        Registry.addToCreativeTab(item);
    }

    @Override
    public IEventBus getWootEventBus() {
        return this.wootBus;
    }

    public static RegistryObject<? extends WootUpgradeItem> get(String name) {
        return REGISTRY.get(name);
    }

    public static boolean has(String name) {
        return REGISTRY.containsKey(name);
    }

    public static Collection<RegistryObject<? extends WootUpgradeItem>> getValues() {
        return REGISTRY.values();
    }

    public static String getNameFromItem(RegistryObject<? extends WootUpgradeItem> item) {
        return item.getId().toString().replaceAll("[^a-zA-Z0-9_]", "_");
    }

    public static String getNameFromItem(WootUpgradeItem item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).toString().replaceAll("[^a-zA-Z0-9_]", "_");
    }

    public static void register(IEventBus bus) {
        ITEMS.register(bus);
        Registry.addToCreativeTab(UPGRADE_BASE_ITEM);
        WootPlugins.registerUpgradeItems(new UpgradeItemsRegistry(bus));
    }
}

