/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.upgrades;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.api.interfaces.WootSpawnProperties;
import wootrevived.api.registrations.WootUpgradeItemRegistration;
import wootrevived.woot.util.render.WootStyles;

public class Dimension
extends WootUpgradeItem {
    private final ResourceKey<Level> dimension;
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ITEMS, (String)"woot_revived");
    public static final String NETHER_DIMENSION_TAG = "nether_dimension_upgrade";
    public static final RegistryObject<Dimension> NETHER_DIMENSION_ITEM = ITEMS.register("nether_dimension_upgrade", () -> new Dimension((ResourceKey<Level>)Level.f_46429_));
    public static final String END_DIMENSION_TAG = "end_dimension_upgrade";
    public static final RegistryObject<Dimension> END_DIMENSION_ITEM = ITEMS.register("end_dimension_upgrade", () -> new Dimension((ResourceKey<Level>)Level.f_46430_));

    public Dimension(ResourceKey<Level> dimension) {
        super(new Item.Properties(), 1);
        this.dimension = dimension;
    }

    @Override
    public void applySpawnProperties(WootSpawnProperties properties, CompoundTag upgradeTag) {
        properties.setDimension(this.dimension);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (this.dimension == Level.f_46429_) {
            tooltip.add((Component)Component.m_237115_((String)"info.woot_revived.upgrade.dimension.desc.nether").m_6270_(WootStyles.DESCRIPTION_STYLE));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"info.woot_revived.upgrade.dimension.desc.end").m_6270_(WootStyles.DESCRIPTION_STYLE));
        }
    }

    public static void register(WootUpgradeItemRegistration registration) {
        ITEMS.register(registration.getWootEventBus());
        registration.register(NETHER_DIMENSION_ITEM);
        registration.register(END_DIMENSION_ITEM);
    }
}

