/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.upgrades;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.api.interfaces.WootGenerationProperties;
import wootrevived.api.registrations.WootUpgradeItemRegistration;
import wootrevived.woot.util.render.WootStyles;

public class Efficiency
extends WootUpgradeItem {
    private static final float[] PERCENTAGES = new float[]{10.0f, 20.0f, 30.0f, 40.0f, 50.0f};
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ITEMS, (String)"woot_revived");
    public static final String COPPER_EFFICIENCY_TAG = "copper_efficiency_upgrade";
    public static final RegistryObject<Efficiency> COPPER_EFFICIENCY_ITEM = ITEMS.register("copper_efficiency_upgrade", () -> new Efficiency(1));
    public static final String IRON_EFFICIENCY_TAG = "iron_efficiency_upgrade";
    public static final RegistryObject<Efficiency> IRON_EFFICIENCY_ITEM = ITEMS.register("iron_efficiency_upgrade", () -> new Efficiency(2));
    public static final String GOLD_EFFICIENCY_TAG = "gold_efficiency_upgrade";
    public static final RegistryObject<Efficiency> GOLD_EFFICIENCY_ITEM = ITEMS.register("gold_efficiency_upgrade", () -> new Efficiency(3));
    public static final String DIAMOND_EFFICIENCY_TAG = "diamond_efficiency_upgrade";
    public static final RegistryObject<Efficiency> DIAMOND_EFFICIENCY_ITEM = ITEMS.register("diamond_efficiency_upgrade", () -> new Efficiency(4));
    public static final String NETHERITE_EFFICIENCY_TAG = "netherite_efficiency_upgrade";
    public static final RegistryObject<Efficiency> NETHERITE_EFFICIENCY_ITEM = ITEMS.register("netherite_efficiency_upgrade", () -> new Efficiency(5));

    public Efficiency(int level) {
        super(new Item.Properties(), level);
    }

    @Override
    public void applyGenerationProperties(WootGenerationProperties properties, CompoundTag upgradeTag) {
        int cost = properties.getVitalityFuelCost();
        float ratio = 1.0f - PERCENTAGES[this.getLevel() - 1] / 100.0f;
        properties.setVitalityFuelCost((int)Math.ceil((float)cost * ratio));
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"info.woot_revived.upgrade.efficiency.desc.0", (Object[])new Object[]{Float.valueOf(PERCENTAGES[this.getLevel() - 1])}).m_6270_(WootStyles.DESCRIPTION_STYLE));
    }

    public static void register(WootUpgradeItemRegistration registration) {
        ITEMS.register(registration.getWootEventBus());
        registration.register(COPPER_EFFICIENCY_ITEM);
        registration.register(IRON_EFFICIENCY_ITEM);
        registration.register(GOLD_EFFICIENCY_ITEM);
        registration.register(DIAMOND_EFFICIENCY_ITEM);
        registration.register(NETHERITE_EFFICIENCY_ITEM);
    }
}

