/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.upgrades;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.api.interfaces.WootGenerationProperties;
import wootrevived.api.registrations.WootUpgradeItemRegistration;
import wootrevived.woot.util.render.WootStyles;

public class Rate
extends WootUpgradeItem {
    private static final int[] PERCENTAGES = new int[]{10, 20, 30, 50, 75};
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ITEMS, (String)"woot_revived");
    public static final String COPPER_RATE_TAG = "copper_rate_upgrade";
    public static final RegistryObject<Rate> COPPER_RATE_ITEM = ITEMS.register("copper_rate_upgrade", () -> new Rate(1));
    public static final String IRON_RATE_TAG = "iron_rate_upgrade";
    public static final RegistryObject<Rate> IRON_RATE_ITEM = ITEMS.register("iron_rate_upgrade", () -> new Rate(2));
    public static final String GOLD_RATE_TAG = "gold_rate_upgrade";
    public static final RegistryObject<Rate> GOLD_RATE_ITEM = ITEMS.register("gold_rate_upgrade", () -> new Rate(3));
    public static final String DIAMOND_RATE_TAG = "diamond_rate_upgrade";
    public static final RegistryObject<Rate> DIAMOND_RATE_ITEM = ITEMS.register("diamond_rate_upgrade", () -> new Rate(4));
    public static final String NETHERITE_RATE_TAG = "netherite_rate_upgrade";
    public static final RegistryObject<Rate> NETHERITE_RATE_ITEM = ITEMS.register("netherite_rate_upgrade", () -> new Rate(5));

    public Rate(int level) {
        super(new Item.Properties(), level);
    }

    @Override
    public void applyGenerationProperties(WootGenerationProperties properties, CompoundTag upgradeTag) {
        int rate = properties.getSpawnRate();
        float ratio = 1.0f - (float)PERCENTAGES[this.getLevel() - 1] / 100.0f;
        properties.setSpawnRate((int)Math.ceil((float)rate * ratio));
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"info.woot_revived.upgrade.rate.desc.0", (Object[])new Object[]{PERCENTAGES[this.getLevel() - 1]}).m_6270_(WootStyles.DESCRIPTION_STYLE));
    }

    public static void register(WootUpgradeItemRegistration registration) {
        ITEMS.register(registration.getWootEventBus());
        registration.register(COPPER_RATE_ITEM);
        registration.register(IRON_RATE_ITEM);
        registration.register(GOLD_RATE_ITEM);
        registration.register(DIAMOND_RATE_ITEM);
        registration.register(NETHERITE_RATE_ITEM);
    }
}

