/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.util.render.WootShapes;

public abstract class FactoryBlockBase
extends Block
implements EntityBlock {
    protected final Supplier<BlockEntityType<?>> entity;

    public FactoryBlockBase(Supplier<BlockEntityType<?>> entity, BlockBehaviour.Properties properties) {
        super(properties);
        this.entity = entity;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61386_});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61431_});
    }

    public void m_5707_(@NotNull Level level, @NotNull BlockPos pos, BlockState state, @NotNull Player player) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
            super.m_5707_(level, pos, state, player);
        }
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return this.entity.get().m_155264_(pos, state);
    }

    public boolean verifyItem(Item item) {
        return item == this.m_5456_();
    }

    public static class State
    extends BlockState {
        public State(Block block, ImmutableMap<Property<?>, Comparable<?>> map, MapCodec<BlockState> codec) {
            super(block, map, codec);
        }

        @NotNull
        public VoxelShape m_60651_(@NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
            if (!((Boolean)this.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
                return WootShapes.disabledShape;
            }
            if (((Boolean)this.m_61143_((Property)BlockStateProperties.f_61386_)).booleanValue()) {
                return Shapes.m_83144_();
            }
            return WootShapes.nonAttachedShape;
        }

        @NotNull
        public RenderShape m_60799_() {
            if (((Boolean)this.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue() && ((Boolean)this.m_61143_((Property)BlockStateProperties.f_61386_)).booleanValue()) {
                return RenderShape.MODEL;
            }
            return RenderShape.ENTITYBLOCK_ANIMATED;
        }

        public float m_60625_(@NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
            if (((Boolean)this.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
                return super.m_60625_(player, level, pos);
            }
            return 0.0f;
        }

        public boolean m_60710_(@NotNull LevelReader level, @NotNull BlockPos pos) {
            if (((Boolean)this.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
                return super.m_60710_(level, pos);
            }
            return true;
        }

        @NotNull
        public PushReaction m_60811_() {
            if (((Boolean)this.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
                return super.m_60811_();
            }
            return PushReaction.BLOCK;
        }

        @NotNull
        public VoxelShape m_60812_(@NotNull BlockGetter level, @NotNull BlockPos pos) {
            if (((Boolean)this.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
                return super.m_60812_(level, pos);
            }
            return Shapes.m_83040_();
        }

        @NotNull
        public VoxelShape m_60742_(@NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
            if (((Boolean)this.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
                return super.m_60742_(level, pos, context);
            }
            return Shapes.m_83040_();
        }

        public boolean m_60796_(@NotNull BlockGetter level, @NotNull BlockPos pos) {
            return this.m_61138_((Property)BlockStateProperties.f_61386_) && (Boolean)this.m_61143_((Property)BlockStateProperties.f_61386_) != false;
        }

        public boolean m_60828_(@NotNull BlockGetter level, @NotNull BlockPos pos) {
            if (((Boolean)this.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
                return super.m_60828_(level, pos);
            }
            return false;
        }

        public boolean m_60831_(@NotNull BlockGetter level, @NotNull BlockPos pos) {
            if (((Boolean)this.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
                return super.m_60831_(level, pos);
            }
            return false;
        }
    }
}

