/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.common;

import com.google.common.base.CaseFormat;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import wootrevived.woot.util.render.WootStyles;

public enum MachineSide {
    FRONT,
    BACK,
    TOP,
    BOTTOM,
    RIGHT,
    LEFT;


    public static MachineSide byIndex(int index) {
        if (index < 0 && index >= MachineSide.values().length) {
            return FRONT;
        }
        return MachineSide.values()[index];
    }

    public static MachineSide getMachineSide(Direction facing, Direction side) {
        if (side == BACK.getRealDirection(facing)) {
            return BACK;
        }
        if (side == TOP.getRealDirection(facing)) {
            return TOP;
        }
        if (side == BOTTOM.getRealDirection(facing)) {
            return BOTTOM;
        }
        if (side == LEFT.getRealDirection(facing)) {
            return LEFT;
        }
        if (side == RIGHT.getRealDirection(facing)) {
            return RIGHT;
        }
        return FRONT;
    }

    public Direction getRealDirection(Direction facing) {
        if (this == BACK) {
            return facing.m_122424_();
        }
        if (this == TOP) {
            return Direction.UP;
        }
        if (this == BOTTOM) {
            return Direction.DOWN;
        }
        if (this == LEFT) {
            return facing.m_122427_();
        }
        if (this == RIGHT) {
            return facing.m_122428_();
        }
        return facing;
    }

    public MutableComponent getDirectionComponent(Direction facing) {
        Direction realDirection = this.getRealDirection(facing);
        return Component.m_237113_((String)("[" + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, realDirection.m_7912_()) + "]")).m_6270_(WootStyles.DIRECTION_STYLE);
    }

    public MutableComponent getComponent() {
        return Component.m_237113_((String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.toString()));
    }
}

