/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class WootConcatFluidStack {
    final Fluid fluid;
    final CompoundTag tag;

    public WootConcatFluidStack(Fluid fluid, CompoundTag tag) {
        this.fluid = fluid;
        this.tag = tag;
    }

    public int hashCode() {
        return Objects.hash(this.fluid, this.tag);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WootConcatFluidStack)) {
            return false;
        }
        WootConcatFluidStack stack = (WootConcatFluidStack)o;
        return this.fluid == stack.fluid && Objects.equals(this.tag, stack.tag);
    }

    public static List<FluidStack> merge(List<FluidStack> unconcatFluids) {
        HashMap<WootConcatFluidStack, FluidStack> map = new HashMap<WootConcatFluidStack, FluidStack>();
        for (FluidStack fluidStack : unconcatFluids) {
            if (fluidStack.isEmpty()) continue;
            WootConcatFluidStack stack = new WootConcatFluidStack(fluidStack.getFluid(), fluidStack.getTag());
            if (map.containsKey(stack)) {
                FluidStack existing = (FluidStack)map.get(stack);
                existing.grow(fluidStack.getAmount());
                continue;
            }
            map.put(stack, fluidStack.copy());
        }
        return new ArrayList<FluidStack>(map.values());
    }
}

