/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.factory;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.enums.Tier;
import wootrevived.api.interfaces.WootSpawnProperties;
import wootrevived.woot.drops.simulator.DropSimulator;

public class WootFactorySpawnProperties
implements WootSpawnProperties {
    private final Tier factoryTier;
    private final WootFactoryMob<?> factoryMob;
    private CompoundTag factoryMobTag;
    private final ServerLevel heartLevel;
    private final BlockPos heartPos;
    private ItemStack mainHandItem = Items.f_42393_.m_7968_();
    private ItemStack offHandItem = ItemStack.f_41583_;
    private float luck = 0.0f;
    private boolean isEnderDragonAlreadyKilled = true;
    private boolean isInFire = false;
    private boolean doSimulateChargedCreeper = false;
    private ResourceKey<Level> dimension = Level.f_46428_;

    public WootFactorySpawnProperties(Tier factoryTier, WootFactoryMob<?> factoryMob, CompoundTag factoryMobTag, ServerLevel heartLevel, BlockPos heartPos) {
        this.factoryTier = factoryTier;
        this.factoryMob = factoryMob;
        this.factoryMobTag = factoryMobTag;
        this.heartLevel = heartLevel;
        this.heartPos = heartPos;
    }

    @Override
    @NotNull
    public ItemStack getMainHandItem() {
        return this.mainHandItem;
    }

    @Override
    public void setMainHandItem(@NotNull ItemStack itemStack) {
        this.mainHandItem = itemStack;
    }

    @Override
    @NotNull
    public ItemStack getOffHandItem() {
        return this.offHandItem;
    }

    @Override
    public void setOffHandItem(@NotNull ItemStack itemStack) {
        this.offHandItem = itemStack;
    }

    @Override
    public float getLuck() {
        return this.luck;
    }

    @Override
    public void setLuck(float luck) {
        this.luck = luck;
    }

    @Override
    public boolean doSimulateChargedCreeper() {
        return this.doSimulateChargedCreeper;
    }

    @Override
    public void setDoSimulateChargedCreeper(boolean doSimulateChargedCreeper) {
        this.doSimulateChargedCreeper = doSimulateChargedCreeper;
    }

    @Override
    public boolean isEnderDragonAlreadyKilled() {
        return this.isEnderDragonAlreadyKilled;
    }

    @Override
    public void setEnderDragonAlreadyKilled(boolean isEnderDragonAlreadyKilled) {
        this.isEnderDragonAlreadyKilled = isEnderDragonAlreadyKilled;
    }

    @Override
    public boolean isInFire() {
        return this.isInFire;
    }

    @Override
    public void setIsInFire(boolean isInFire) {
        this.isInFire = isInFire;
    }

    @Override
    @NotNull
    public ServerLevel getLevel() {
        return DropSimulator.getLevel();
    }

    @Override
    @NotNull
    public RandomSource getRandom() {
        return DropSimulator.getRandom();
    }

    @Override
    @NotNull
    public HolderLookup.Provider getLookupProvider() {
        return DropSimulator.getLookupProvider();
    }

    @Override
    @NotNull
    public Tier getFactoryTier() {
        return this.factoryTier;
    }

    @Override
    @NotNull
    public WootFactoryMob<?> getFactoryMob() {
        return this.factoryMob;
    }

    @Override
    @NotNull
    public CompoundTag getFactoryMobTag() {
        return this.factoryMobTag.m_6426_();
    }

    @Override
    public void setFactoryMobTag(CompoundTag tag) {
        if (!tag.m_128461_("id").equals(this.factoryMobTag.m_128461_("id"))) {
            return;
        }
        this.factoryMobTag = tag;
    }

    @Override
    @NotNull
    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    @Override
    public void setDimension(@NotNull ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    @Override
    @NotNull
    public ServerLevel getHeartLevel() {
        return this.heartLevel;
    }

    @Override
    @NotNull
    public BlockPos getHeartPos() {
        return this.heartPos;
    }
}

