/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.handlers;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;

public class WootEnergyStorage
extends EnergyStorage
implements INBTSerializable<Tag> {
    public WootEnergyStorage(int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
    }

    protected void onEnergyChanged() {
    }

    public void setEnergy(int energy) {
        this.energy = energy;
        this.onEnergyChanged();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int res = super.receiveEnergy(maxReceive, simulate);
        this.onEnergyChanged();
        return res;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int res = super.extractEnergy(maxExtract, simulate);
        this.onEnergyChanged();
        return res;
    }

    public int internalExtractEnergy(int maxExtract, boolean simulate) {
        if (maxExtract <= 0) {
            return 0;
        }
        int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Energy", this.getEnergyStored());
        return tag;
    }

    public void deserializeNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)nbt;
            this.setEnergy(tag.m_128451_("Energy"));
        }
    }
}

