/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class WootImportFluidHandler
implements IFluidHandler {
    private final Map<Integer, List<FluidStack>> importFluids = new HashMap<Integer, List<FluidStack>>();
    private final Map<Integer, List<Integer>> tanks = new HashMap<Integer, List<Integer>>();

    public void setImportFluid(int index, List<FluidStack> importFluid) {
        if (this.isEqual(this.importFluids.get(index), importFluid)) {
            return;
        }
        this.importFluids.put(index, importFluid);
        if (importFluid != null) {
            this.tanks.put(index, new ArrayList<Integer>(Collections.nCopies(importFluid.size(), 0)));
        }
    }

    private boolean isEqual(List<FluidStack> list1, List<FluidStack> list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            FluidStack fluid1 = list1.get(i);
            FluidStack fluid2 = list2.get(i);
            if (fluid1.getAmount() != fluid2.getAmount()) {
                return false;
            }
            if (fluid1.isFluidEqual(fluid2)) continue;
            return false;
        }
        return true;
    }

    public boolean isImportValid(int index) {
        List<FluidStack> list = this.importFluids.get(index);
        if (list == null) {
            return true;
        }
        List<Integer> amounts = this.tanks.get(index);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getAmount() == amounts.get(i).intValue()) continue;
            return false;
        }
        return true;
    }

    public void consume(int index) {
        List<Integer> amounts = this.tanks.get(index);
        if (amounts == null) {
            return;
        }
        Collections.fill(amounts, 0);
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        int capacity = 0;
        for (int i = 0; i < 4; ++i) {
            List<FluidStack> list = this.importFluids.get(i);
            if (list == null) continue;
            for (FluidStack stack : list) {
                if (capacity >= stack.getAmount()) continue;
                capacity = stack.getAmount();
            }
        }
        return capacity;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        for (int i = 0; i < 4; ++i) {
            List<FluidStack> list = this.importFluids.get(i);
            if (list == null) continue;
            for (FluidStack s : list) {
                if (!s.isFluidEqual(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isFluidValid(0, resource) || resource.isEmpty()) {
            return 0;
        }
        resource = resource.copy();
        int filled = 0;
        for (int i = 0; i < 4; ++i) {
            List<FluidStack> list = this.importFluids.get(i);
            if (list == null) continue;
            List<Integer> tank = this.tanks.get(i);
            for (int j = 0; j < list.size(); ++j) {
                FluidStack stack = list.get(j);
                if (!stack.isFluidEqual(resource)) continue;
                int amount = tank.get(j);
                int needToBeFill = stack.getAmount() - amount;
                if (resource.getAmount() <= needToBeFill) {
                    filled += resource.getAmount();
                    if (!action.simulate()) {
                        tank.set(j, amount + resource.getAmount());
                    }
                    return filled;
                }
                filled += needToBeFill;
                if (!action.simulate()) {
                    tank.set(j, amount + needToBeFill);
                }
                resource.shrink(needToBeFill);
            }
        }
        return filled;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    public void save(CompoundTag tag) {
        ListTag list = new ListTag();
        for (int i = 0; i < 4; ++i) {
            CompoundTag compoundTag = new CompoundTag();
            List<FluidStack> stackList = this.importFluids.get(i);
            compoundTag.m_128379_("IsNull", stackList == null);
            if (stackList == null) {
                list.add((Object)compoundTag);
                continue;
            }
            ListTag stackListTag = new ListTag();
            for (int j = 0; j < stackList.size(); ++j) {
                CompoundTag stackTag = new CompoundTag();
                FluidStack fluidStack = stackList.get(j);
                CompoundTag fluidTag = new CompoundTag();
                fluidStack.writeToNBT(fluidTag);
                stackTag.m_128365_("Fluid", (Tag)fluidTag);
                stackTag.m_128405_("Amount", this.tanks.get(i).get(j).intValue());
                stackListTag.add((Object)stackTag);
            }
            compoundTag.m_128365_("Stacks", (Tag)stackListTag);
            list.add((Object)compoundTag);
        }
        tag.m_128365_("FluidHandler", (Tag)list);
    }

    public void load(CompoundTag tag) {
        this.importFluids.clear();
        this.tanks.clear();
        ListTag list = tag.m_128437_("FluidHandler", 10);
        for (int i = 0; i < 4; ++i) {
            CompoundTag compoundTag = list.m_128728_(i);
            if (compoundTag.m_128471_("IsNull")) continue;
            ListTag stackListTag = compoundTag.m_128437_("Stacks", 10);
            ArrayList<FluidStack> stackList = new ArrayList<FluidStack>();
            ArrayList<Integer> tanks = new ArrayList<Integer>();
            for (int j = 0; j < stackListTag.size(); ++j) {
                CompoundTag stackTag = stackListTag.m_128728_(j);
                CompoundTag fluid = stackTag.m_128469_("Fluid");
                stackList.add(FluidStack.loadFluidStackFromNBT((CompoundTag)fluid));
                tanks.add(stackTag.m_128451_("Amount"));
            }
            this.importFluids.put(i, stackList);
            this.tanks.put(i, tanks);
        }
    }
}

